---
name: disaster-recovery-plan-writer
version: 1.0.0
---

# Disaster Recovery Plan Writer - Initialization

Generate comprehensive IT disaster recovery plans with RTO/RPO definitions, backup strategies, failover procedures, communication plans, testing protocols, and compliance requirements. Supports cloud-native (AWS, Azure, GCP), hybrid, and on-premises environments with four DR strategy tiers and detailed runbooks.

## Package Structure

```
disaster-recovery-plan-writer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r disaster-recovery-plan-writer/ ~/.claude/skills/disaster-recovery-plan-writer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Describe your infrastructure and recovery requirements to generate a DR plan

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{infrastructure_type}}` | `hybrid-cloud` | Environment type: cloud-native, multi-cloud, hybrid-cloud, on-premises, edge-distributed |
| `{{critical_systems}}` | `web-application, database, object-storage` | Comma-separated critical systems: web-application, database, object-storage, message-queue, container-orchestration, identity-provider, email, erp, file-server |
| `{{rto_target}}` | `1-hour` | Recovery Time Objective: near-zero, 15-minutes, 1-hour, 4-hours, 24-hours, 72-hours |
| `{{rpo_target}}` | `5-minutes` | Recovery Point Objective: near-zero, seconds, 5-minutes, 1-hour, 4-hours, 24-hours |
| `{{budget_tier}}` | `mid-range` | DR budget: minimal ($0-$10K), low ($10K-$50K), mid-range ($50K-$150K), high ($150K-$500K), enterprise ($500K+) |

## Quick Usage Examples

### Hybrid Cloud E-Commerce DR Plan

```
Create a disaster recovery plan for:
- Infrastructure: Hybrid cloud (AWS primary, on-premises secondary datacenter)
- Critical systems: PostgreSQL database cluster, Kubernetes workloads, S3 object storage, Redis cache
- RTO target: 1 hour for Tier 1, 4 hours for Tier 2
- RPO target: 5 minutes for databases, 1 hour for file storage
- Budget: Mid-range ($50K-$150K annual)
- Compliance: SOC 2 Type II, PCI DSS
- Include: Full BIA, warm standby recommendation, AWS failover runbooks, quarterly test schedule
```

### Healthcare Multi-Cloud DR Plan

```
Create a disaster recovery plan for:
- Infrastructure: Multi-cloud (Azure primary, AWS secondary)
- Critical systems: Azure SQL database, HL7 FHIR API, blob storage with PHI, identity provider
- RTO target: 15 minutes for patient-facing systems, 4 hours for internal
- RPO target: Near-zero for patient records, 1 hour for reporting
- Budget: High ($150K-$500K annual)
- Compliance: HIPAA, HITECH, SOC 2
- Include: ePHI-specific backup encryption, Azure Site Recovery procedures, HIPAA contingency plan mapping
```

### SaaS Startup Cloud-Native DR Plan

```
Create a disaster recovery plan for:
- Infrastructure: Cloud-native (AWS single cloud)
- Critical systems: Aurora PostgreSQL, ECS Fargate services, S3, ElastiCache Redis, SQS queues
- RTO target: 1 hour
- RPO target: 5 minutes
- Budget: Low ($10K-$50K annual)
- Compliance: SOC 2 Type II
- Include: Cost-optimized pilot light strategy, Aurora Global Database setup, Route 53 failover, minimal DR spend
```

### Enterprise On-Premises DR Plan

```
Create a disaster recovery plan for:
- Infrastructure: On-premises (two datacenters, 500 miles apart)
- Critical systems: Oracle RAC database, VMware vSphere cluster, NetApp SAN, Exchange Server, SAP ERP
- RTO target: 4 hours for Tier 1, 24 hours for Tier 2
- RPO target: 1 hour for databases, 24 hours for file shares
- Budget: High ($150K-$500K annual)
- Compliance: ISO 27001, SOC 2, GDPR
- Include: SAN replication, VMware Site Recovery Manager procedures, tape backup rotation, air-gapped backups
```

## Key Features

- **NIST SP 800-34 Framework**: Complete contingency planning lifecycle from BIA through plan maintenance
- **4 DR Strategy Tiers**: Backup-restore, pilot light, warm standby, and multi-site active-active with architecture diagrams and cost estimates
- **Business Impact Analysis**: Full BIA template with impact assessment, dependency mapping, and system tier classification
- **Cloud-Specific DR**: Detailed procedures for AWS (Aurora Global, Route 53, S3 CRR), Azure (ASR, SQL Failover Groups, Cosmos DB), and GCP (Cloud Spanner, Global LB, GKE Multi-Cluster)
- **Backup Framework**: 3-2-1-1-0 rule, immutable backups, air-gapped storage, scheduled backup matrices
- **Database DR**: Replication strategies, PITR for PostgreSQL/MySQL/MongoDB, logical vs. physical backups, failover decision trees
- **Application DR**: Stateless vs. stateful recovery, Kubernetes multi-cluster failover, DNS failover with TTL strategies
- **Communication Plan**: Stakeholder notification matrix, internal status templates, executive briefs, customer notices, vendor contacts
- **DR Testing Framework**: Six test types (tabletop through full failover), test report templates, annual testing schedule
- **Scenario Runbooks**: Cloud region failure, database corruption, ransomware requiring DR activation, critical vendor outage
- **Compliance Mapping**: SOC 2, HIPAA, PCI DSS 4.0, ISO 27001, NIST CSF, GDPR, FedRAMP, CMMC with audit evidence checklists
- **Cost Estimation**: Per-strategy cost breakdowns, downtime cost vs. DR investment framework, 3-year TCO template
- **Plan Maintenance**: Review triggers, annual checklist, version control, distribution list

## DR Strategy Summary

| Strategy | RTO | RPO | Monthly Cost | Best For |
|----------|-----|-----|-------------|----------|
| Backup & Restore | 4-24+ hours | Hours | $280-$2,800 | Tier 3-4, dev, archives |
| Pilot Light | 1-4 hours | Minutes | $710-$4,250 | Tier 2-3, databases |
| Warm Standby | 10-30 min | Seconds-min | $1,790-$10,550 | Tier 1-2, production |
| Active-Active | Seconds-min | Near-zero | $8,850-$78,000 | Tier 1, zero downtime |

## Compliance Standards Covered

| Standard | DR Requirement | Key Citation |
|----------|---------------|-------------|
| SOC 2 | Availability criteria (A1.1-A1.5) | Trust Services Criteria |
| HIPAA | Contingency Plan | 164.308(a)(7) |
| PCI DSS 4.0 | IR plan including recovery | Requirement 12.10 |
| ISO 27001 | Business continuity | Annex A.17 |
| NIST CSF | Recovery planning | RC.RP |
| GDPR | Restore data availability | Article 32(1)(c) |
| FedRAMP | Contingency planning | CP-1 through CP-13 |
| CMMC | Recovery controls | RE.2.137, RE.3.139 |

## Companion Skills

- **Incident Response Playbook Builder** - Tactical response procedures that activate alongside DR plans
- **Cloud Security Auditor** - Audit cloud security posture to identify DR-relevant vulnerabilities
- **Network Architecture Reviewer** - Review network for redundancy, failover paths, and single points of failure
- **Monitoring & Alerting Designer** - Design monitoring that detects failures early and triggers DR activation

## Best Practices

**Do:**
- Complete BIA with actual business owners before setting RTO/RPO targets
- Test backup restoration monthly (untested backups are not backups)
- Store DR documentation offline and in physical format at the DR site
- Update the DR plan within 2 weeks of any major infrastructure change
- Include cost justification (downtime cost vs. DR investment) for executive buy-in
- Practice runbooks before you need them (quarterly tabletop exercises minimum)

**Don't:**
- Assume backups are good because the backup job completed (verify with restore tests)
- Store the DR plan only in systems that may be unavailable during a disaster
- Skip the BIA (without it, you are guessing at recovery priorities)
- Set RTO/RPO targets without budget alignment (near-zero targets require enterprise budgets)
- Forget to update the plan after infrastructure changes, incidents, or team changes
- Test only annually (monthly component tests catch drift before it becomes critical)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
