---
name: docker-security-auditor
version: 1.0.0
---

# Initialization

Audit Dockerfiles, docker-compose files, and container configurations for security vulnerabilities. Covers CIS Docker Benchmark controls, image hardening (base image selection, multi-stage builds, non-root execution), secrets management, network isolation, capability dropping, runtime security (read-only filesystem, seccomp, no-new-privileges), container scanning (Trivy, Grype, Snyk), and image supply chain security (signing, SBOM, provenance).

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Docker security audit instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Audit Dockerfiles** - Review base image selection, tag pinning, multi-stage builds, USER directives, secrets in ENV/ARG/COPY, ADD vs COPY, health checks, and .dockerignore completeness
2. **Audit Docker Compose files** - Review network isolation, volume mount restrictions, resource limits, secrets management, restart policies, privileged mode, and capability configuration
3. **Enforce non-root execution** - Verify containers run as non-root users with specific UID/GID and proper file ownership
4. **Detect embedded secrets** - Find passwords, API keys, tokens, and credentials in Dockerfiles, Compose files, and image layers
5. **Review runtime security** - Assess read-only filesystems, no-new-privileges flags, seccomp profiles, and AppArmor/SELinux configurations
6. **Map to CIS Docker Benchmark** - Reference specific CIS controls for every finding with control IDs
7. **Recommend scanning tools** - Guide users through Trivy, Grype, Snyk, and Docker Bench Security for vulnerability scanning
8. **Audit image supply chain** - Review image signing (Docker Content Trust, Cosign), SBOM generation, and build provenance
9. **Review registry security** - Assess private registry configuration, TLS, authentication, and access control
10. **Generate corrected code** - Provide fully hardened versions of Dockerfiles and docker-compose.yml files with every finding fixed

## Audit Coverage

### Dockerfile Controls
- Base image: version pinning, digest pinning, minimal images, official images
- Build: multi-stage builds, COPY vs ADD, layer minimization, package cleanup
- User: non-root USER directive, UID/GID specification, file ownership
- Secrets: no ENV/ARG secrets, no .env COPY, BuildKit secret mounts
- Health: HEALTHCHECK directive, appropriate checks per language
- Ignore: .dockerignore file completeness

### Docker Compose Controls
- Network: custom networks, internal networks, no host networking
- Capabilities: cap_drop ALL, minimal cap_add, no privileged mode
- Resources: memory limits, CPU limits, PIDs limits, ulimits
- Volumes: read-only mounts, no Docker socket, no host system dirs
- Secrets: Docker Secrets, external vault integration, no plaintext
- Security: no-new-privileges, seccomp profiles, restart policies

### Runtime Controls
- Read-only root filesystem with tmpfs for writable paths
- Seccomp profiles (default or custom)
- AppArmor/SELinux enforcement
- Container vulnerability scanning in CI/CD

### Supply Chain Controls
- Image signing with Docker Content Trust or Cosign (Sigstore)
- SBOM generation with Trivy or Syft
- Build provenance with Docker BuildKit
- Private registry with TLS and htpasswd authentication

## CIS Docker Benchmark Coverage

Key controls audited:
- 4.1: Container user created (non-root)
- 4.3: Unnecessary packages not installed
- 4.6: HEALTHCHECK instructions added
- 4.7: Update instructions not used alone (version pinning)
- 4.9: COPY used instead of ADD
- 4.10: Secrets not stored in Dockerfiles
- 5.3: Linux kernel capabilities restricted
- 5.4: Privileged containers not used
- 5.5: Sensitive host directories not mounted
- 5.10: Memory limits set
- 5.11: CPU limits set
- 5.12: Read-only root filesystem
- 5.21: Default seccomp profile not disabled
- 5.25: No additional privileges acquired
- 5.28: PIDs limit set
- 5.29: Host network namespace not shared
- 5.31: Docker socket not mounted

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides commands for container scanning tools (Trivy, Grype, Snyk, Docker Bench Security) and image signing tools (Cosign, Docker Content Trust) but does not require them to be pre-installed.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r docker-security-auditor/ ~/.claude/skills/docker-security-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{dockerfile_content}}` | `Paste your Dockerfile here` | The Dockerfile to audit |
| `{{docker_compose_content}}` | `Paste your docker-compose.yml here` | The docker-compose.yml to audit |
| `{{base_image}}` | `ubuntu:latest` | The base image used in the Dockerfile |
| `{{compliance_standard}}` | `CIS Docker Benchmark` | The compliance framework to audit against |
| `{{deployment_environment}}` | `production` | Where the containers will run |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
