---
name: incident-response-playbook-builder
version: 1.0.0
---

# Incident Response Playbook Builder - Initialization

Build SOC-ready incident response playbooks with NIST SP 800-61 framework coverage for ransomware, data breach, DDoS, insider threat, phishing, supply chain compromise, and business email compromise attacks. Includes roles, escalation paths, communication templates, evidence preservation, and tabletop exercises.

## Package Structure

```
incident-response-playbook-builder/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r incident-response-playbook-builder/ ~/.claude/skills/incident-response-playbook-builder/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Describe your incident type and organization context to generate a playbook

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{incident_type}}` | `ransomware` | Attack scenario: ransomware, data_breach, ddos, insider_threat, phishing_campaign, supply_chain, business_email_compromise |
| `{{organization_size}}` | `mid-market` | Organization scale: startup (1-50), smb (50-500), mid-market (500-2000), enterprise (2000+) |
| `{{industry_sector}}` | `technology` | Industry vertical: technology, healthcare, finance, government, retail, manufacturing, education |
| `{{compliance_requirements}}` | `SOC2` | Regulatory frameworks: SOC2, HIPAA, PCI-DSS, GDPR, CCPA, NIST-CSF, CMMC, FedRAMP, ISO-27001 |
| `{{team_structure}}` | `shared_responsibility` | IR team model: dedicated_soc, shared_responsibility, managed_soc, hybrid |

## Quick Usage Examples

### Healthcare Ransomware Playbook

```
Build an incident response playbook for:
- Incident type: Ransomware attack
- Organization: Mid-market healthcare provider (800 employees)
- Compliance: HIPAA, HITECH
- Team: Shared responsibility model (IT team doubles as IR)
- Include: HIPAA notification timelines, patient data considerations, HHS reporting
```

### Financial Services Data Breach Playbook

```
Build an incident response playbook for:
- Incident type: Data breach (customer financial records)
- Organization: Enterprise financial services firm (5,000 employees)
- Compliance: PCI-DSS, SOX, GLBA, state breach notification laws
- Team: Dedicated SOC (12 analysts) with external IR firm on retainer
- Include: Card brand notification procedures, SEC filing templates, customer remediation
```

### Government DDoS Playbook

```
Build an incident response playbook for:
- Incident type: DDoS targeting public-facing services
- Organization: State government agency
- Compliance: NIST-CSF, FedRAMP, CISA requirements
- Team: Hybrid model (internal analysts + managed SOC provider)
- Include: CISA coordination procedures, citizen communication, multi-agency escalation
```

### Startup Phishing Playbook

```
Build an incident response playbook for:
- Incident type: Phishing campaign targeting all employees
- Organization: SaaS startup (120 employees, fully remote)
- Compliance: SOC2 Type II
- Team: No dedicated security - engineering team handles incidents
- Include: Simplified roles for small team, cloud-first containment (Google Workspace/M365)
```

## Key Features

- **NIST SP 800-61 Framework**: Complete 6-phase lifecycle coverage (Preparation, Detection & Analysis, Containment, Eradication, Recovery, Post-Incident)
- **7 Attack-Specific Playbooks**: Ransomware, data breach, DDoS, insider threat, phishing campaign, supply chain compromise, business email compromise
- **Severity Classification Matrix**: P1-P4 with SLA targets and escalation triggers
- **5 IR Team Roles**: Incident Commander, Technical Lead, Communications Lead, Legal Counsel, Executive Sponsor
- **Escalation Decision Trees**: Visual escalation paths with severity-based triggers
- **Communication Templates**: Internal status, executive brief, customer notification, regulatory filing, press statement
- **Evidence Preservation Protocol**: Chain of custody, forensic imaging checklist, log retention requirements
- **Tabletop Exercise Scenarios**: 4 ready-to-use scenarios for quarterly playbook validation
- **Legal Compliance Reference**: Breach notification timelines for GDPR, HIPAA, CCPA, PCI-DSS, PIPEDA, SEC, and US state laws
- **Response Metrics**: MTTD, MTTR, containment time, eradication time, recovery time tracking

## NIST SP 800-61 Phases Covered

| Phase | Key Deliverables |
|-------|------------------|
| Preparation | Asset inventory, tool readiness, contact lists, training requirements |
| Detection & Analysis | Detection sources, triage checklist, severity matrix, IOC documentation |
| Containment | Short-term isolation, long-term stabilization, evidence preservation, decision trees |
| Eradication | Malware removal, vulnerability remediation, credential reset, verification |
| Recovery | Staged restoration, post-restoration monitoring, data integrity validation |
| Post-Incident | Retrospective, metrics calculation, report distribution, playbook updates |

## Incident Types Supported

| Type | Key Focus Areas |
|------|----------------|
| Ransomware | Isolation, variant ID, backup assessment, pay/no-pay framework, hardening |
| Data Breach | Scope assessment, classification, forensics, legal notifications, dark web monitoring |
| DDoS | Traffic analysis, provider coordination, attack type mitigation, smokescreen detection |
| Insider Threat | Legal-first approach, covert investigation, HR coordination, simultaneous revocation |
| Phishing Campaign | Email quarantine, credential reset, payload escalation, user communication |
| Supply Chain | Vendor assessment, lateral movement check, SBOM review, component isolation |
| Business Email Compromise | Financial hold, FBI IC3 reporting, verification protocols, permanent controls |

## Companion Skills

- **Incident Postmortem Generator** - Use AFTER incident resolution for root cause analysis and lessons learned
- **Cloud Security Auditor** - Audit cloud security posture to prevent incidents
- **Security Review Checklist Generator** - Security checklists for code, infrastructure, and processes
- **SOC 2 Compliance Checker** - Validate SOC 2 compliance controls

## Best Practices

**Do:**
- Customize generated playbooks with actual team contacts and system names
- Conduct tabletop exercises quarterly using the included scenarios
- Update playbooks after every real incident
- Store playbooks in offline-accessible locations (not only in potentially compromised systems)
- Test out-of-band communication channels before an incident

**Don't:**
- Use playbooks without organizational customization
- Skip the preparation phase (most response failures stem from poor preparation)
- Assume the playbook covers every scenario (use as framework, adapt in real-time)
- Forget to update contact lists (monthly review minimum)
- Store playbooks only in digital systems that may be unavailable during an incident

---
Downloaded from [Find Skill.ai](https://findskill.ai)
