---
name: log-analysis-detective
version: 1.0.0
---

# Log Analysis Detective - Initialization

Analyze application, system, and security logs to identify issues, anomalies, and attack patterns. Supports JSON, syslog (RFC 5424/3164), Apache/Nginx combined, CloudWatch Logs, Windows Event Log, and journald formats. Includes command-line recipes (grep, awk, jq), SIEM query patterns (ELK/Splunk), CloudWatch Logs Insights queries, security threat detection, cross-source correlation, and root cause analysis methodology.

## Package Structure

```
log-analysis-detective/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r log-analysis-detective/ ~/.claude/skills/log-analysis-detective/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Provide your log samples and investigation context

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{log_sample}}` | *(empty)* | Paste your log entries here. Supports JSON, syslog, Apache/Nginx, CloudWatch, Windows Event Log, or journald format. |
| `{{log_format}}` | `auto-detect` | Log format: json, syslog-rfc5424, syslog-rfc3164, apache-combined, nginx-combined, cloudwatch, windows-event, journald, csv, auto-detect |
| `{{investigation_goal}}` | `identify errors and anomalies` | What you are investigating: error-spikes, latency-analysis, auth-failures, security-incident, traffic-anomaly, root-cause, general-health |
| `{{time_range}}` | `last 24 hours` | Time window: last-1h, last-24h, last-7d, last-30d, or custom range |
| `{{system_context}}` | *(empty)* | Brief description of your system architecture: tech stack, infrastructure, key services, databases, load balancers |

## Quick Usage Examples

### Application Error Debugging

```
Analyze these Node.js API logs:
- Log format: JSON
- Investigation goal: Find root cause of 502 errors between 14:00-14:30 UTC
- Time range: Last 7 days
- System context: Node.js API behind Nginx, deployed on Kubernetes, PostgreSQL database

{"timestamp":"2026-02-22T14:12:03Z","level":"error","msg":"upstream timeout","service":"api-gateway","duration_ms":30012}
{"timestamp":"2026-02-22T14:12:04Z","level":"warn","msg":"connection pool exhausted","service":"user-service","pool_size":20,"waiting":47}
```

### Security Incident Investigation

```
Analyze these auth logs for a potential breach:
- Log format: syslog
- Investigation goal: Determine if brute force succeeded and what was accessed
- Time range: Last 48 hours
- System context: Ubuntu 22.04 web server running Nginx + Django, exposed to internet

Feb 22 14:01:12 web-01 sshd[12345]: Failed password for admin from 203.0.113.50 port 54321 ssh2
Feb 22 14:01:14 web-01 sshd[12345]: Failed password for admin from 203.0.113.50 port 54322 ssh2
Feb 22 14:05:22 web-01 sshd[12346]: Accepted password for admin from 203.0.113.50 port 54400 ssh2
```

### Web Server Performance Analysis

```
Analyze these Nginx access logs for latency issues:
- Log format: nginx-combined (with $request_time appended)
- Investigation goal: Identify slow endpoints and traffic patterns
- Time range: Last 24 hours
- System context: Nginx reverse proxy fronting 3 upstream microservices

203.0.113.50 - - [22/Feb/2026:14:00:01 +0000] "GET /api/users HTTP/1.1" 200 4523 "-" "Mozilla/5.0" 0.234
203.0.113.51 - - [22/Feb/2026:14:00:02 +0000] "GET /api/reports/export HTTP/1.1" 200 1048576 "-" "Mozilla/5.0" 12.456
```

### CloudWatch Log Analysis

```
Analyze these AWS Lambda logs:
- Log format: cloudwatch
- Investigation goal: Investigate cold start impact and timeout errors
- Time range: Last 3 days
- System context: AWS Lambda (Node.js 18) behind API Gateway, DynamoDB backend

2026-02-22T14:00:00.123Z  abc-123  INFO  Init Duration: 1234.56 ms
2026-02-22T14:00:01.456Z  abc-123  ERROR  Task timed out after 30.00 seconds
```

### Windows Security Event Analysis

```
Analyze these Windows security events:
- Log format: windows-event
- Investigation goal: Detect privilege escalation or unauthorized access
- Time range: Last 7 days
- System context: Windows Server 2022 Active Directory domain controller

Look for: Event IDs 4625 (failed logon), 4672 (special privileges), 4720 (account created), 4732 (group membership changed), 1102 (audit log cleared)
```

## Key Features

- **6 Log Formats**: JSON, Syslog (RFC 5424/3164), Apache/Nginx combined, CloudWatch, Windows Event Log, journald
- **Auto-Detection**: Identifies format from log samples without manual configuration
- **Error Rate Analysis**: Baseline comparison, spike detection, error grouping, deployment correlation
- **Latency Profiling**: P50/P95/P99 percentile calculation per endpoint
- **Authentication Analysis**: Brute force detection, credential stuffing, success-after-failure patterns
- **HTTP Status Analysis**: 4xx vs 5xx distribution, endpoint-specific error rates, scanner detection
- **Traffic Anomaly Detection**: Volume anomalies, bot detection, geographic patterns
- **Security Threat Detection**: Privilege escalation, data exfiltration, lateral movement, web attack signatures (SQLi, XSS, path traversal, command injection)
- **Cross-Source Correlation**: Merge events across log sources using timestamps, IPs, users, request IDs
- **Timeline Reconstruction**: Chronological incident timelines with MITRE ATT&CK mapping
- **Command-Line Recipes**: grep, awk, sed, jq recipes for every analysis task
- **SIEM Queries**: ELK (KQL/Lucene) and Splunk SPL patterns
- **CloudWatch Insights**: AWS CloudWatch Logs Insights query patterns
- **Root Cause Analysis**: 5 Whys methodology adapted for log-based investigation
- **Alerting Rules**: Log-based alert definitions with severity levels and fatigue prevention
- **Retention Guidelines**: Log retention recommendations by type with compliance considerations (HIPAA, PCI, SOC2, GDPR)

## Analysis Phases

| Phase | Focus Area |
|-------|-----------|
| Format ID & Parsing | Auto-detect format, extract structured fields, normalize timestamps |
| Error & Performance | Error rate spikes, latency percentiles, HTTP status patterns, traffic anomalies |
| Security Analysis | Auth failures, privilege escalation, data exfiltration, lateral movement, web attacks |
| Correlation | Cross-source event correlation using shared keys (IP, user, timestamp, request ID) |
| Timeline | Chronological reconstruction, MITRE ATT&CK mapping, kill chain identification |
| Command-Line | grep/awk/jq recipes, SIEM queries (ELK, Splunk), CloudWatch Insights |
| Alerting | Alert rule definitions, severity tuning, fatigue prevention |
| Root Cause | 5 Whys with log evidence, contributing factors, remediation plan |
| Retention | Rotation config, retention periods, compliance requirements |

## Security Event Reference

### Windows Event IDs
| Event ID | Description | Relevance |
|----------|-------------|-----------|
| 4624 | Successful logon | Baseline, anomaly detection |
| 4625 | Failed logon | Brute force, credential stuffing |
| 4648 | Explicit credential logon | Lateral movement |
| 4672 | Special privileges assigned | Privilege escalation |
| 4688 | Process created | Malware execution |
| 4720 | Account created | Unauthorized account |
| 4732 | Group membership changed | Privilege escalation |
| 1102 | Audit log cleared | Anti-forensics |

### Syslog Severity Levels
| Level | Name | Analysis Priority |
|-------|------|-------------------|
| 0 | Emergency | Immediate investigation |
| 1 | Alert | Immediate investigation |
| 2 | Critical | High priority |
| 3 | Error | Standard analysis |
| 4 | Warning | Monitor for trends |
| 5-7 | Notice/Info/Debug | Context and baseline |

## Companion Skills

- **Monitoring & Alerting Designer** - Build dashboards and alerts from log analysis findings
- **Incident Response Playbook Builder** - Structured response for incidents discovered through logs
- **Kubernetes Troubleshooter** - Kubernetes-specific log analysis (pod logs, events, cluster state)
- **DevOps Expert** - Broad DevOps guidance for CI/CD, infrastructure, and operations

## Best Practices

**Do:**
- Provide system context (architecture, tech stack) alongside log samples
- Include logs from multiple sources for complex investigations
- Verify NTP synchronization across systems before correlating timestamps
- Set up alerting rules after resolving issues to prevent recurrence
- Use the root cause analysis template for post-incident documentation

**Don't:**
- Analyze logs from a single source for complex incidents (correlation reveals the full picture)
- Ignore warning-level logs (they often precede errors and reveal the degradation timeline)
- Skip the baseline step in error rate analysis (without a baseline, spikes cannot be quantified)
- Share raw logs containing PII/secrets without redaction
- Delete logs before completing an investigation (preserve evidence)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
