---
name: network-architecture-reviewer
version: 1.0.0
---

# Initialization

Review network architecture diagrams and configurations for security, performance, redundancy, and scalability issues. Covers VPC/VNet design, CIDR planning, subnet architecture, firewall rules, load balancing, DNS architecture, hybrid/multi-cloud networking patterns, monitoring, high availability, and cost optimization across AWS, Azure, and GCP.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with network architecture review instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Gather architecture context** - Ask structured questions about cloud providers, topology, workloads, traffic patterns, compliance, and availability targets
2. **Review VPC/VNet design** - Audit CIDR planning, subnet architecture (public/private/isolated), NAT configuration, and VPC interconnection (peering, Transit Gateway, PrivateLink)
3. **Audit network security** - Review security groups, NACLs, WAF placement, DDoS protection, network segmentation, micro-segmentation, and east-west traffic inspection
4. **Review load balancing** - Evaluate ALB vs NLB vs CLB selection, global load balancing, health check configuration, and SSL/TLS termination placement
5. **Audit DNS architecture** - Check split-horizon DNS, private hosted zones, failover routing policies, DNSSEC, DNS over HTTPS, and DNS query logging
6. **Review hybrid connectivity** - Assess site-to-site VPN (dual tunnels, IKEv2, BGP), client VPN security, Direct Connect/ExpressRoute redundancy, and transit architecture
7. **Evaluate multi-cloud networking** - Review cross-cloud connectivity, consistent IP planning, and cross-cloud DNS resolution
8. **Assess monitoring and observability** - Verify VPC Flow Logs, packet mirroring, and network performance monitoring across providers
9. **Review high availability** - Audit multi-AZ deployment (LB, app, DB, NAT per AZ), multi-region patterns (active-active vs active-passive), and failover procedures
10. **Optimize network costs** - Identify NAT Gateway data processing waste, recommend VPC endpoints, flag cross-AZ/cross-region transfer costs, and unused resources
11. **Flag anti-patterns** - Detect flat networks, single AZ deployments, public databases, open management ports, overlapping CIDRs, missing flow logs, and more

## Supported Cloud Providers

- **AWS**: VPC, Subnets, Security Groups, NACLs, ALB, NLB, CloudFront, Global Accelerator, Route 53, NAT Gateway, Transit Gateway, VPC Peering, PrivateLink, Direct Connect, VPN, Shield, WAF, Network Firewall, VPC Flow Logs, Traffic Mirroring
- **Azure**: VNet, Subnets, NSGs, Azure Firewall, Front Door, Application Gateway, Traffic Manager, Azure DNS, NAT Gateway, VNet Peering, Private Link, ExpressRoute, VPN Gateway, DDoS Protection, WAF, Network Watcher, NSG Flow Logs
- **GCP**: VPC, Subnets, Firewall Rules, Cloud Load Balancing, Cloud CDN, Cloud DNS, Cloud NAT, VPC Peering, Private Service Connect, Cloud Interconnect, Cloud VPN, Cloud Armor, Cloud Firewall, VPC Flow Logs, Packet Mirroring

## Review Framework

- **Defense in Depth**: DDoS > WAF > Firewall > NACLs > Security Groups > mTLS
- **Segmentation Tiers**: Edge/DMZ > Application > Data > Management > Restricted/Compliance
- **Severity Tiers**: CRITICAL > HIGH > MEDIUM > LOW > INFORMATIONAL
- **Finding Categories**: SECURITY, PERFORMANCE, RELIABILITY, SCALABILITY, COST, COMPLIANCE

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides CLI commands for cloud provider CLIs (aws, az, gcloud) and references tools like Prowler and Checkov, but does not require them to be pre-installed.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r network-architecture-reviewer/ ~/.claude/skills/network-architecture-reviewer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{architecture_description}}` | `AWS VPC with public and private subnets across 2 AZs` | Description of your current network architecture or diagram |
| `{{cloud_provider}}` | `AWS` | Primary cloud provider for the network review |
| `{{network_requirements}}` | `High availability, low latency, PCI-DSS compliant` | Specific network requirements or constraints |
| `{{compliance_needs}}` | `PCI-DSS` | Compliance frameworks that affect network design |
| `{{traffic_patterns}}` | `Web application with 10K concurrent users, API traffic, batch data processing` | Expected traffic patterns and volumes |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
