---
name: penetration-test-report-writer
version: 1.0.0
description: Professional penetration test report writer with CVSS 3.1 scoring, executive summaries, finding documentation templates, remediation roadmaps, and compliance mapping for authorized security testing engagements
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps penetration testers and security professionals write professional, actionable pentest reports. It covers the complete report lifecycle from executive summaries to detailed finding documentation with CVSS scoring, evidence presentation, remediation prioritization, and compliance mapping.

**What this skill enables:**
- Write complete penetration test reports following PTES, OWASP, and NIST SP 800-115 standards
- Score findings with CVSS 3.1 including full vector string justification
- Write executive summaries in business language for non-technical stakeholders
- Document findings with proof of concept, evidence, and remediation guidance
- Prioritize remediation using risk-based and effort-based frameworks
- Tailor reports for different audiences (technical teams, executives, compliance auditors)
- Map findings to PCI DSS 4.0, HIPAA, SOC 2, ISO 27001, and NIST CSF
- Generate retesting checklists and verification procedures
- Handle report classification, delivery, and retention requirements

**Time to initialize:** ~1 minute (prompt-only skill, no scripts required)

## Directory Structure

```
penetration-test-report-writer/
├── SKILL.md          # Main pentest report writing instructions and templates
└── INIT.md           # This initialization manifest
```

## Dependencies

This is a prompt-only skill with no hard dependencies. The skill references standard penetration testing tools and frameworks:

**Report Standards:**
- PTES (Penetration Testing Execution Standard) - Report structure
- OWASP WSTG v4.2 - Web security testing methodology
- NIST SP 800-115 - Information security testing guide
- OSSTMM 3.0 - Security testing methodology

**Scoring Systems:**
- CVSS v3.1 (Common Vulnerability Scoring System)
- CWE (Common Weakness Enumeration)
- CVE (Common Vulnerabilities and Exposures)

**Compliance Frameworks:**
- PCI DSS 4.0
- HIPAA Security Rule
- SOC 2 (Trust Services Criteria)
- ISO 27001:2022
- NIST Cybersecurity Framework

## Files to Generate

This is a **prompt-only skill** -- no scripts or additional files need to be generated. The complete pentest report writing framework is contained in SKILL.md.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
mkdir -p ~/.claude/skills/penetration-test-report-writer
cp SKILL.md INIT.md ~/.claude/skills/penetration-test-report-writer/
```

Then reference the skill when documenting penetration test findings.

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation context
4. Start your pentest report writing conversation

## Quick Start Examples

### Example 1: Full Penetration Test Report

```
User: I completed an external penetration test for a healthcare SaaS
      platform. I found SQL injection in the patient search endpoint,
      weak password policy on the admin portal, missing rate limiting
      on the login page, and an exposed S3 bucket with PHI data.
      The client needs a report for both the dev team and the CISO.
      Help me write a professional report with CVSS scoring.

AI: I'll create a comprehensive penetration test report. Let me start
    with the structure:

    1. Executive Summary (for the CISO)
    2. Engagement Overview (scope, methodology, tools)
    3. Risk Summary (severity distribution)
    4. Detailed Findings (4 findings with CVSS scoring)
    5. Remediation Roadmap
    6. HIPAA Compliance Mapping

    Starting with the most critical finding:

    FINDING: ACME-2026-001 - SQL Injection in Patient Search API
    SEVERITY: Critical
    CVSS: 9.1 (CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N)

    [Continues with full finding documentation, executive summary,
    and remediation roadmap...]
```

### Example 2: Executive Summary Only

```
User: Write an executive summary for a pentest that found 2 critical,
      4 high, 6 medium, and 3 low vulnerabilities in an e-commerce
      platform processing credit card payments.

AI: EXECUTIVE SUMMARY

    [Company] engaged [Testing Firm] to perform a web application
    penetration test of the e-commerce platform during [dates].

    OVERALL RISK RATING: HIGH

    The assessment identified 15 vulnerabilities. Most critically,
    an attacker could gain full access to the payment processing
    system and customer credit card data within approximately
    3 hours of effort...

    [Continues with business-impact language, no jargon,
    PCI DSS compliance implications, and timeline...]
```

### Example 3: Single Finding Documentation

```
User: Document this finding: I found stored XSS in the product review
      comments on shop.example.com. An unauthenticated user can submit
      a review containing JavaScript that executes when an admin views
      the review moderation page.

AI: FINDING ID: [PROJ]-2026-[SEQ]
    TITLE: Stored Cross-Site Scripting in Product Review Comments
    SEVERITY: Critical
    CVSS: 9.3 (CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:N)

    Justification: Network-accessible (AV:N), no special conditions
    (AC:L), no authentication needed to submit review (PR:N), admin
    must view the page (UI:R), scope changed because admin's browser
    is impacted (S:C), high C/I because admin session can be hijacked...

    [Continues with full finding template including description,
    business impact, proof of concept, evidence guidelines,
    and multi-phase remediation...]
```

### Example 4: CVSS Scoring Help

```
User: Help me score this finding: SSRF vulnerability in the webhook
      URL validation feature. An authenticated user can provide an
      internal URL that the server fetches, allowing access to the
      AWS metadata endpoint and IAM credentials.

AI: Let me walk through each CVSS 3.1 metric:

    Attack Vector (AV): Network (N) - exploitable over the internet
    Attack Complexity (AC): Low (L) - no special conditions needed
    Privileges Required (PR): Low (L) - requires authenticated user
    User Interaction (UI): None (N) - no victim interaction needed
    Scope (S): Changed (C) - impacts AWS infrastructure beyond the app
    Confidentiality (C): High (H) - IAM credentials = full cloud access
    Integrity (I): High (H) - credentials allow infrastructure modification
    Availability (A): High (H) - credentials allow resource deletion

    CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H = 9.9 (Critical)

    Note: Even though PR:L (authenticated), the scope change to
    cloud infrastructure makes this near-maximum severity...
```

### Example 5: Compliance Mapping

```
User: Map my SQL injection and weak authentication findings to
      PCI DSS 4.0 and HIPAA requirements.

AI: COMPLIANCE MAPPING

    SQL Injection:
    - PCI DSS 4.0: Req 6.2.4 (prevent common software attacks)
    - HIPAA: §164.312(a)(1) (access control - technical safeguards)
    - HIPAA: §164.312(e)(1) (transmission security)

    Weak Authentication:
    - PCI DSS 4.0: Req 8.3 (strong authentication for users/admins)
    - PCI DSS 4.0: Req 8.6 (multi-factor authentication)
    - HIPAA: §164.312(d) (person or entity authentication)

    Impact Assessment:
    These findings together indicate non-compliance with PCI DSS
    Requirements 6 and 8, which could result in...
```

## Compatibility

**Tested with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4 Turbo, GPT-4o)
- Gemini (Gemini Pro, Gemini Ultra)
- GitHub Copilot Chat
- Llama 3 (70B+)
- Mistral Large

**Works best with:** Claude and GPT-4 for comprehensive report writing with accurate CVSS scoring and compliance mapping.

## Variables

Customize these placeholders for your specific engagement:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{finding_description}}` | (describe vulnerability) | The vulnerability discovered during testing |
| `{{severity_level}}` | `High` | Severity classification (Critical, High, Medium, Low, Info) |
| `{{affected_systems}}` | (list systems) | IP addresses, hostnames, URLs, or components affected |
| `{{testing_scope}}` | (describe scope) | Target environment, IP ranges, applications, exclusions |
| `{{audience_type}}` | `technical` | Primary audience: technical, executive, or compliance |

## Key Sections in SKILL.md

1. **Report Structure** - Complete template from cover page to appendices
2. **Finding Template** - Structured format for documenting each vulnerability
3. **CVSS 3.1 Quick Reference** - Metrics, severity ranges, common vector examples
4. **Common Finding Categories** - Injection, auth, access control, configuration, crypto, server-side
5. **Executive Summary Writing** - Business language guidelines and template
6. **Remediation Prioritization** - Risk/effort matrix and roadmap phases
7. **Evidence Redaction** - Guidelines for handling sensitive data in reports
8. **Report Delivery** - Classification, encryption, distribution requirements

## Recommended Workflow

1. **Gather engagement details** - Test type, scope, methodology, tools used
2. **List all findings** - Vulnerability, affected system, severity estimate
3. **Score with CVSS 3.1** - Generate vector string with metric justification
4. **Document each finding** - Description, impact, PoC, evidence, remediation
5. **Write executive summary** - Business language, risk focus, no jargon
6. **Build remediation roadmap** - Prioritize by risk and effort
7. **Map to compliance frameworks** - PCI DSS, HIPAA, SOC 2, ISO 27001 as applicable
8. **Add evidence** - Screenshots with redaction, request/response captures
9. **Quality review** - Verify accuracy, consistency, and completeness
10. **Deliver securely** - Encrypted channel, named recipients only

## Additional Resources

- PTES Reporting Guidelines: http://www.pentest-standard.org/index.php/Reporting
- OWASP WSTG: https://owasp.org/www-project-web-security-testing-guide/
- NIST SP 800-115: https://csrc.nist.gov/publications/detail/sp/800-115/final
- FIRST CVSS v3.1: https://www.first.org/cvss/v3.1/specification-document
- OSSTMM 3.0: https://www.isecom.org/OSSTMM.3.pdf
- CVSS Calculator: https://www.first.org/cvss/calculator/3.1

---

Downloaded from [Find Skill.ai](https://findskill.ai)
