---
name: phishing-email-detector
version: 1.0.0
description: AI-powered phishing email detection and social engineering analysis skill covering header forensics, sender verification, link analysis, attachment risk evaluation, and pattern classification against 10 common attack types
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms any AI assistant into a phishing email detection specialist. It provides a structured 9-phase analysis framework for identifying phishing emails, business email compromise (BEC) attacks, and social engineering attempts.

**What this skill enables:**
- Analyze email headers (SPF, DKIM, DMARC, Received chain, Return-Path, Message-ID)
- Verify sender legitimacy (typosquatting detection, display name analysis, Reply-To comparison)
- Detect social engineering tactics (urgency, authority, fear, curiosity, reward manipulation)
- Evaluate URLs and links (domain analysis, homograph attacks, URL shortener detection)
- Assess attachment risk (file type classification, double extension detection, password-protected archive warning)
- Classify attacks against 10 known phishing patterns (CEO fraud, credential harvesting, invoice scams, package delivery, tax/government, tech support, shared document, payroll/HR, voicemail/MFA, sextortion)
- Generate risk scores (0-100 across 4 categories) with actionable recommendations
- Provide emergency response guidance if the user has already interacted with the phishing email

**Time to initialize:** ~1 minute (prompt-only skill, no scripts required)

## Directory Structure

```
phishing-email-detector/
├── index.md          # Hugo page with full skill_content (500+ lines)
├── SKILL.md          # Condensed skill instructions for direct use
└── INIT.md           # This initialization manifest
```

## Dependencies

This is a prompt-only skill with no dependencies. However, the skill references these free tools that users may find helpful:

**Email Header Analysis:**
- Gmail: "Show original" in three-dot menu
- Outlook Desktop: File > Properties > Internet headers
- Outlook Web: View > View message source
- Apple Mail: View > Message > All Headers

**URL Scanning:**
- VirusTotal (https://virustotal.com) - Scan suspicious URLs and files
- URLScan.io (https://urlscan.io) - Analyze and visualize URL behavior

**Breach Checking:**
- Have I Been Pwned (https://haveibeenpwned.com) - Check for email/password exposure in data breaches

**Domain Analysis:**
- WHOIS Lookup (https://whois.domaintools.com) - Check domain registration details
- MXToolbox (https://mxtoolbox.com) - Verify SPF, DKIM, DMARC records

## Files to Generate

This is a **prompt-only skill** - no scripts or additional files need to be generated. The complete phishing analysis framework is contained in SKILL.md and the full version in index.md.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
mkdir -p ~/.claude/skills/phishing-email-detector
cp SKILL.md INIT.md ~/.claude/skills/phishing-email-detector/
```

Then reference the skill in your Claude Code sessions by mentioning phishing email analysis.

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as context for your conversation
4. Share the suspicious email for analysis

## Quick Start Examples

### Example 1: Full Email Analysis

```
User: I received this email from "Microsoft Security Team <security@micr0soft-alerts.com>"
      saying my account was accessed from Russia and I need to click a link to verify
      my identity within 24 hours.

AI: === PHISHING ANALYSIS REPORT ===

    RISK SCORE: 78/100 - CRITICAL

    SUMMARY: This email exhibits multiple strong phishing indicators including
    domain typosquatting (micr0soft vs microsoft), artificial urgency (24-hour
    deadline), fear-based manipulation (unauthorized access from Russia), and
    a credential harvesting pattern.

    KEY RED FLAGS:
    1. Domain typosquatting: "micr0soft-alerts.com" uses zero instead of 'o'
       and adds "-alerts" to the legitimate domain
    2. 24-hour urgency deadline - classic fear tactic
    3. Credential harvesting pattern - link leads to fake login page

    RECOMMENDED ACTIONS:
    1. Do NOT click the link
    2. Go directly to account.microsoft.com to check your account
    3. Report the email using Outlook's "Report Phishing" button
    4. Delete the email
```

### Example 2: CEO Fraud Detection

```
User: My CEO just emailed asking me to wire $15,000 to a new vendor.
      The email says it's confidential and not to tell anyone. The sender
      is ceo@mycompany-inc.com but our domain is mycompany.com.

AI: === PHISHING ANALYSIS REPORT ===

    RISK SCORE: 85/100 - CRITICAL

    CLASSIFICATION: CEO Fraud / Business Email Compromise (BEC)

    This is a textbook CEO fraud attack. The domain "mycompany-inc.com" is
    different from your real domain "mycompany.com" - this is typosquatting.
    The emphasis on confidentiality is designed to prevent you from verifying
    the request with colleagues.

    RECOMMENDED ACTIONS:
    1. Do NOT wire any money
    2. Call your CEO directly using a known phone number to verify
    3. Report to your IT security team immediately
    4. Forward the email to your IT security team for investigation
```

### Example 3: Header Analysis

```
User: I got the full email headers. Here they are:
      Authentication-Results: spf=softfail; dkim=none; dmarc=fail
      Return-Path: <randomuser@cheap-vps.xyz>
      From: "PayPal Support" <support@paypal.com>

AI: === HEADER ANALYSIS ===

    SPF: SOFTFAIL - The sending server is NOT authorized to send on behalf
    of the claimed domain. This is a strong red flag.

    DKIM: NONE - No DKIM signature present. PayPal signs all legitimate
    emails with DKIM. This absence is a strong red flag.

    DMARC: FAIL - The message fails DMARC alignment. This is a strong red flag.

    Return-Path: MISMATCH - The envelope sender (randomuser@cheap-vps.xyz)
    does not match the display From address (support@paypal.com). This is
    definitive evidence of email spoofing.

    RISK SCORE for headers alone: 23/25 - Almost all header checks fail.
    This email is NOT from PayPal.
```

## Compatibility

**Tested with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Gemini Pro, Gemini Ultra)
- GitHub Copilot Chat

**Works best with:** Claude and GPT-4 for comprehensive analysis with detailed explanations.

## Variables

Customize these placeholders for your specific situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_email_address}}` | `me@mycompany.com` | My email address that received the message |
| `{{my_organization}}` | `My Company` | My organization name for context |
| `{{my_industry}}` | `Technology` | My industry sector (helps identify targeted attacks) |
| `{{my_role}}` | `Employee` | My job role (helps assess spear-phishing risk) |
| `{{risk_tolerance}}` | `medium` | My organization's risk tolerance level |

## Key Sections in SKILL.md

1. **Context Gathering & Emergency Response** - Initial triage and immediate actions if user already interacted
2. **Header Analysis** - SPF, DKIM, DMARC, Return-Path, Received chain, Message-ID forensics
3. **Sender Legitimacy** - Display name, email address, and Reply-To analysis
4. **Content & Psychology** - Social engineering tactic identification and urgency scoring
5. **Link & URL Analysis** - Domain inspection, homograph detection, URL shortener flagging
6. **Attachment Analysis** - File type risk classification and filename red flags
7. **Pattern Classification** - 10 known phishing patterns with verification steps
8. **Risk Scoring** - 0-100 quantitative assessment across 4 categories
9. **Preventive Guidance** - Personal and organizational security recommendations

## Recommended Workflow

1. **Paste the suspicious email** into the AI conversation with this skill loaded
2. **Provide email headers** if available (the skill explains how to get them from each email client)
3. **Answer context questions** about your role, organization, and whether you were expecting the email
4. **Review the risk score and report** generated by the AI
5. **Follow the recommended actions** (do not click, verify through separate channels, report)
6. **Implement preventive measures** based on the guidance provided

## Additional Resources

- OWASP Phishing Prevention: https://cheatsheetseries.owasp.org/cheatsheets/Phishing_Prevention_Cheat_Sheet.html
- NIST Trustworthy Email: https://csrc.nist.gov/publications/detail/sp/800-177/rev-1/final
- CISA Phishing Guidance: https://www.cisa.gov/topics/cybersecurity-best-practices/phishing
- APWG Trend Reports: https://apwg.org/trendsreports/
- FBI IC3 Reporting: https://www.ic3.gov
- Have I Been Pwned: https://haveibeenpwned.com
- VirusTotal: https://virustotal.com

---

Downloaded from [Find Skill.ai](https://findskill.ai)
