---
name: privacy-settings-optimizer
version: 1.0.0
description: Comprehensive privacy settings optimizer covering iOS, Android, Windows, macOS, Google, Facebook, Instagram, TikTok, LinkedIn, browser privacy, app permissions, ad/location tracking, data broker opt-outs, and smart device privacy
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive, platform-by-platform guide to auditing and hardening privacy settings across all major devices, operating systems, social media platforms, browsers, and online services. It is designed for users of any technical level who want to reduce data collection, ad tracking, location surveillance, and data broker exposure.

**What this skill enables:**
- Audit and optimize privacy settings on iOS, Android, Windows, and macOS
- Harden privacy on Google, Facebook, Instagram, TikTok, and LinkedIn accounts
- Configure browser privacy in Chrome, Safari, Firefox, Edge, and Brave
- Audit app permissions and identify suspicious access patterns
- Disable advertising identifiers and cross-app tracking on all platforms
- Opt out of major data brokers (Spokeo, WhitePages, BeenVerified, Acxiom, etc.)
- Set up private DNS and evaluate VPN options
- Secure smart speakers and smart TVs against data harvesting
- Establish a quarterly privacy maintenance routine

**Time to initialize:** ~1 minute (prompt-only skill, no scripts required)

## Directory Structure

```
privacy-settings-optimizer/
├── SKILL.md          # Condensed privacy optimization guide
└── INIT.md           # This initialization manifest
```

## Dependencies

This is a prompt-only skill with no software dependencies. The skill references these external tools and services that users may optionally use:

**Browser extensions:**
- uBlock Origin — ad and tracker blocker
- Privacy Badger (EFF) — learns to block invisible trackers
- Facebook Container (Firefox) — isolates Facebook tracking
- Cookie AutoDelete — clears cookies when tabs close

**Privacy services:**
- DeleteMe, Kanary, or Optery — automated data broker removal
- ProtonMail or Tutanota — encrypted email providers
- Mullvad VPN, ProtonVPN, or IVPN — privacy-respecting VPNs
- Bitwarden, 1Password, or ProtonPass — password managers

**DNS providers:**
- Cloudflare (1.1.1.1) — privacy-first DNS
- Quad9 (9.9.9.9) — malware-blocking privacy DNS
- NextDNS — customizable DNS with ad/tracker blocking

## Files to Generate

This is a **prompt-only skill** — no scripts or additional files need to be generated. The complete privacy optimization framework is contained in SKILL.md.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
mkdir -p ~/.claude/skills/privacy-settings-optimizer
cp SKILL.md INIT.md ~/.claude/skills/privacy-settings-optimizer/
```

Then reference the skill in your Claude Code sessions by asking about privacy settings.

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as context for your conversation
4. Tell the AI about your devices, accounts, and browsers
5. Work through the optimization plan platform by platform

## Quick Start Examples

### Example 1: Full Privacy Audit

```
User: I have an iPhone, a Windows laptop, and I use Google, Facebook, Instagram,
      and LinkedIn. I browse with Chrome and Safari. I want balanced privacy.

AI: Let's do a full privacy audit. I'll walk you through every platform.
    Let's start with your iPhone since it has the most impactful single setting...

    First: Settings > Privacy & Security > Tracking
    Turn OFF "Allow Apps to Request to Track"
    This one change blocks ALL apps from tracking you across other apps.

    Done? Great. Now let's go through Location Services...
    [Continues through all relevant platforms]
```

### Example 2: Social Media Privacy Only

```
User: I just want to lock down my Facebook and Instagram. What should I change?

AI: Let's start with Facebook — it has the most privacy settings to adjust.

    First, the most impactful change: Off-Facebook Activity
    Go to: Settings > Your Facebook Information > Off-Facebook Activity
    Tap "Clear History" then "Manage Future Activity" > Turn OFF

    This stops hundreds of websites and apps from sending your
    browsing data to Facebook. Next, let's adjust your profile visibility...
```

### Example 3: Data Broker Removal

```
User: I found my home address and phone number on people-search sites.
      How do I get removed?

AI: This is a common and solvable problem. Data brokers scrape public records
    and re-publish them. Let's opt you out of the major ones.

    Start with the easiest ones first:

    1. TruePeopleSearch — go to truepeoplesearch.com/removal
       Search for your name, find your listing, click "Remove This Record"

    2. FastPeopleSearch — fastpeoplesearch.com/removal
       Same process...

    [Continues through all major brokers]

    Warning: Brokers frequently re-list your data after a few months.
    I recommend checking quarterly, or using a service like DeleteMe ($129/year)
    to monitor and re-remove automatically.
```

### Example 4: Quick Phone Privacy Check

```
User: I just want to make sure my phone isn't leaking data. Quick check?

AI: Let's do a quick privacy check on your phone. What do you use — iPhone or Android?

    [If iPhone]
    Three quick checks that take under 5 minutes:

    1. Settings > Privacy & Security > Tracking
       → "Allow Apps to Request to Track" should be OFF

    2. Settings > Privacy & Security > Apple Advertising
       → "Personalized Ads" should be OFF

    3. Settings > Privacy & Security > Location Services
       → Scroll through and count how many apps have "Always" permission
       → If more than 2-3, we should reduce that list

    How do those look?
```

## Compatibility

**Tested with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Gemini Pro, Gemini Ultra)
- GitHub Copilot Chat

**Works best with:** Claude and GPT-4 for step-by-step privacy walkthroughs with contextual explanations.

## Variables

Customize these placeholders for your specific situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_devices}}` | `iPhone (iOS 18), MacBook (macOS Sequoia), Windows 11 PC` | My devices and operating systems |
| `{{my_accounts}}` | `Google, Facebook, Instagram, TikTok, LinkedIn` | My social media and online accounts |
| `{{my_browsers}}` | `Chrome, Safari` | My web browsers |
| `{{my_priority}}` | `Stop ad tracking and reduce data collection` | My top privacy concern |
| `{{my_comfort_level}}` | `balanced` | My comfort with privacy trade-offs |

## Key Sections in SKILL.md

1. **iOS Privacy Settings** — App Tracking Transparency, Location Services, app permissions, Safari, Siri, iCloud, Apple Advertising
2. **Android Privacy Settings** — Permissions Manager, Privacy Dashboard, Advertising ID, lock screen privacy
3. **Windows Privacy Settings** — General privacy, diagnostics, activity history, Recall/Copilot
4. **macOS Privacy Settings** — System privacy permissions, Safari, FileVault encryption, Firewall
5. **Google Account Privacy** — Web & App Activity, Location History, YouTube History, ad personalization, third-party access
6. **Facebook Privacy** — Profile visibility, Off-Facebook Activity, ad preferences, connected apps
7. **Instagram Privacy** — Account privacy, story controls, ad preferences
8. **TikTok Privacy** — Account suggestions, personalization, ad preferences
9. **LinkedIn Privacy** — Visibility settings, advertising data, profile discovery
10. **Browser Privacy** — Chrome, Safari, Firefox, Edge, Brave with extension recommendations
11. **Data Broker Opt-Outs** — Step-by-step removal from 10+ major brokers plus automated services
12. **Network Privacy** — Private DNS configuration and VPN recommendations
13. **Smart Device Privacy** — Smart speakers and smart TVs

## Recommended Workflow

1. **Start with your phone** — the device that knows the most about you
2. **Lock down social media** — the biggest sources of voluntary data exposure
3. **Fix your browser** — stop cross-site tracking
4. **Adjust OS settings** — Windows/macOS telemetry and diagnostics
5. **Clean up Google** — the company with the most data about most people
6. **Opt out of data brokers** — remove your personal info from people-search sites
7. **Set up quarterly maintenance** — privacy is ongoing, not one-time

## Additional Resources

- EFF Surveillance Self-Defense: https://ssd.eff.org/
- NIST Privacy Framework: https://www.nist.gov/privacy-framework
- Google Privacy Checkup: https://myaccount.google.com/privacycheckup
- Mozilla Privacy Not Included: https://foundation.mozilla.org/en/privacynotincluded/
- Have I Been Pwned: https://haveibeenpwned.com
- Privacy Rights Clearinghouse: https://privacyrights.org/data-brokers
- Consumer Reports Digital Privacy: https://www.consumerreports.org/electronics/privacy/

---

Downloaded from [Find Skill.ai](https://findskill.ai)
