---
name: secrets-management-advisor
version: 1.0.0
---

# Initialization

Guide developers on securely managing secrets (API keys, passwords, tokens, certificates, encryption keys) across development, CI/CD, and production environments. Covers secret stores (HashiCorp Vault, AWS Secrets Manager, Azure Key Vault, GCP Secret Manager, Doppler, 1Password CLI), injection patterns (environment variables, file-based, API-based, sidecar), rotation strategies (zero-downtime dual-credential pattern), leak prevention (gitleaks, trufflehog, GitHub secret scanning), and emergency response for leaked credentials.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with secrets management advisory instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Classify secret types by risk** - Categorize API keys, database credentials, SSH keys, TLS certificates, tokens, and encryption keys into risk tiers (CRITICAL through LOW) with recommended rotation frequencies and blast radius analysis
2. **Recommend secret stores** - Compare HashiCorp Vault, AWS Secrets Manager, Azure Key Vault, GCP Secret Manager, Doppler, and 1Password CLI based on the user's infrastructure, team size, and multi-cloud requirements
3. **Design secret injection patterns** - Implement environment variable injection, file-based mounted secrets, API-based vault fetch, and Kubernetes sidecar patterns (Vault Agent Injector) with working code samples
4. **Secure development environments** - Set up .env files with .gitignore, .env.example templates, direnv, git-crypt, Mozilla SOPS, and pre-commit hooks for local development
5. **Harden CI/CD pipelines** - Configure secrets for GitHub Actions (with OIDC), GitLab CI (protected + masked variables), Jenkins (Credentials Plugin), and CircleCI (Contexts) with security best practices
6. **Manage Kubernetes secrets** - Implement native secrets with encryption at rest, Sealed Secrets (Bitnami), External Secrets Operator, and Vault CSI Provider with complete YAML manifests
7. **Implement secret rotation** - Design zero-downtime rotation using the dual-credential pattern, automated rotation via Vault or AWS Lambda, and TLS certificate rotation with cert-manager
8. **Prevent secret leaks** - Set up gitleaks, trufflehog, GitHub secret scanning with push protection, and CI/CD scanning pipelines with pre-commit hooks
9. **Execute emergency response** - Follow the leaked-secret playbook: revoke, rotate, remove from history, audit logs, assess blast radius, notify stakeholders, and conduct root cause analysis
10. **Assess secrets maturity** - Score the organization's secrets management maturity on a 1-5 scale with a phased remediation roadmap and effort estimates

## Assessment Coverage

### Secret Types Audited
- API keys (payment, general, service-to-service)
- Database credentials (production, staging, development)
- SSH private keys and host keys
- TLS/SSL certificates and private keys
- OAuth client secrets and tokens
- JWT signing keys (HMAC, RSA)
- Encryption keys (AES, RSA)
- Cloud IAM credentials (AWS access keys, GCP service account keys)
- Container registry tokens
- Webhook verification secrets

### Secret Stores Covered
- HashiCorp Vault (OSS and HCP): KV engine, dynamic secrets, PKI, transit encryption, Kubernetes auth, policies
- AWS Secrets Manager: creation, rotation with Lambda, IAM access control, cross-account sharing
- Azure Key Vault: RBAC authorization, soft-delete, purge protection, certificates
- GCP Secret Manager: IAM bindings, automatic replication, version management
- Doppler: environment sync, CLI integration
- 1Password CLI: development workflow integration

### Injection Patterns
- Environment variables with file-reference fallback
- File-based mounted secrets (Kubernetes volumes, Docker secrets, tmpfs)
- API-based direct vault fetch (Python hvac, Go vault client, Node.js)
- Sidecar pattern (Vault Agent Injector with template rendering)
- CSI driver (Secrets Store CSI with Vault provider)

### CI/CD Platforms
- GitHub Actions: repository secrets, environment secrets, OIDC federation
- GitLab CI: protected variables, masked variables, Vault integration (Premium)
- Jenkins: Credentials Plugin, withCredentials pipeline step
- CircleCI: Contexts, organization-level secret management
- Azure DevOps: variable groups, Key Vault integration

### Kubernetes Patterns
- Native secrets with encryption at rest (EncryptionConfiguration)
- Sealed Secrets (Bitnami) for GitOps-safe encrypted secrets
- External Secrets Operator syncing from AWS SM, Vault, Azure KV, GCP SM
- Vault CSI Provider for direct secret mounting
- Vault Agent Injector sidecar for template-based secret rendering

### Rotation Strategies
- Dual-credential zero-downtime pattern
- AWS Secrets Manager automated rotation (4-step Lambda)
- Vault dynamic secrets with TTL-based expiration
- cert-manager for TLS certificate lifecycle
- JWT signing key rotation with JWKS endpoint

### Leak Prevention Tools
- gitleaks: pre-commit hooks, CI scanning, custom rules, allowlists
- trufflehog: Git history scanning, verified-only mode, filesystem scanning
- GitHub Secret Scanning: 200+ provider patterns, push protection
- detect-secrets (Yelp): baseline management, custom plugins

### Compliance Frameworks
- SOC 2: access controls, audit logging, encryption, rotation
- PCI-DSS: requirement 3 (stored data), requirement 8 (access)
- HIPAA: technical safeguards, access controls, audit controls
- ISO 27001: A.10 cryptography, A.9 access control
- FedRAMP: NIST 800-53 controls
- NIST SP 800-57: key management lifecycle

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides commands for secret management tools (HashiCorp Vault, gitleaks, trufflehog, SOPS, kubeseal, cert-manager) and cloud CLIs (aws, az, gcloud) but does not require them to be pre-installed.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r secrets-management-advisor/ ~/.claude/skills/secrets-management-advisor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{secret_type}}` | `API key` | The type of secret to manage |
| `{{environment}}` | `production` | Target deployment environment |
| `{{tech_stack}}` | `Node.js on Kubernetes` | Your technology stack and languages |
| `{{secret_store}}` | `HashiCorp Vault` | Preferred secret store or vault solution |
| `{{compliance_requirements}}` | `SOC 2` | Applicable compliance frameworks |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
