---
name: security-review-checklist-generator
version: 1.0.0
---

# Security Review Checklist Generator - Initialization

Generate comprehensive, context-specific security audit checklists for OWASP Top 10, NIST CSF, PCI-DSS, HIPAA, ISO 27001, and other compliance frameworks. Tailored to your application type, technology stack, and risk level with tool recommendations and remediation guidance.

## Package Contents

```
security-review-checklist-generator/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Quick Start

### Claude Code Installation
```bash
# Copy skill to Claude Code skills directory
cp -r security-review-checklist-generator/ ~/.claude/skills/security-review-checklist-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start a new conversation and describe your security review needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_type}}` | `web_application` | Type of application: web_application, mobile_app, api, microservice, cloud_service, iot, desktop |
| `{{compliance_frameworks}}` | `owasp_top_10, nist_csf` | Standards to include: owasp_top_10, nist_csf, pci_dss, hipaa, gdpr, iso_27001, soc_2, cis_benchmark |
| `{{tech_stack}}` | `Node.js, React, PostgreSQL` | Technologies used in the application |
| `{{risk_level}}` | `high` | Application criticality: critical, high, medium, low |
| `{{include_remediation}}` | `true` | Whether to include fix guidance and code examples |
| `{{output_format}}` | `markdown` | Delivery format: markdown, json, pdf, spreadsheet, jira, interactive |

## Example Prompts

### Pre-Compliance Audit Assessment
```
Generate a comprehensive security review checklist for our Node.js/Express
payment processing application. We handle credit card data and are preparing
for PCI-DSS 4.0 compliance audit in Q1. Include:
- OWASP Top 10 and PCI-DSS requirement mapping
- Recommended SAST/DAST tools for Node.js
- Database security and encryption best practices
- API authentication and rate limiting requirements
- Evidence documentation templates

Format as an interactive checklist we can track progress on in Notion/Jira.
```

### DevSecOps Pipeline Setup
```
I'm setting up automated security scanning for our Kubernetes microservices
on AWS. We have 15 services in Python/Go, use GitHub for repos, GitHub Actions
for CI/CD. Create a security checklist that includes:
- GitHub Actions security best practices (pinned versions, permissions)
- SAST/SCA/secret scanning tool recommendations for Python/Go
- Container image scanning for vulnerabilities
- NIST Cybersecurity Framework mapping
- Critical vs. advisory gating rules for pull requests

Output as JSON so we can integrate with our security dashboard.
```

### Third-Party Vendor Assessment
```
Our healthcare startup needs to evaluate a third-party SaaS vendor who'll
access HIPAA-protected patient data. Generate a vendor security due diligence
checklist covering:
- Application security practices and testing
- Data protection and encryption controls
- Access control and identity management
- Incident response and disaster recovery
- HIPAA compliance certifications and audit reports
- Vendor questionnaire format for compliance team
```

## Supported Compliance Frameworks

| Framework | Focus | When to Use |
|-----------|-------|-------------|
| OWASP Top 10 | Web application vulnerabilities | All web/API applications |
| NIST CSF | Cybersecurity risk management | General security posture |
| PCI-DSS 4.0 | Payment card data protection | Payment processing apps |
| HIPAA | Healthcare data protection | Healthcare applications |
| GDPR | EU personal data protection | Apps handling EU user data |
| ISO 27001 | Information security management | Enterprise compliance |
| SOC 2 | Service organization controls | SaaS providers |
| CIS Benchmarks | System hardening | Infrastructure security |

## Tool Recommendations by Stack

### Node.js/JavaScript
- SAST: ESLint security plugins, Semgrep, SonarQube
- SCA: npm audit, Snyk, OWASP Dependency-Check
- Secrets: GitLeaks, TruffleHog

### Python
- SAST: Bandit, PyLint, Semgrep
- SCA: pip-audit, Safety, Snyk
- Secrets: detect-secrets, GitLeaks

### Java
- SAST: SpotBugs, FindSecBugs, SonarQube
- SCA: OWASP Dependency-Check, Snyk
- Secrets: GitLeaks, TruffleHog

### Container/Kubernetes
- Image Scanning: Trivy, Grype, Docker Scout
- Runtime: Falco, Sysdig
- RBAC: kube-bench, Polaris

## Output Formats

- **Markdown**: Documentation, wikis, README files
- **JSON**: Automation, dashboards, ticketing integration
- **Interactive**: Notion, Jira, Linear import
- **Spreadsheet**: Excel/Google Sheets tracking
- **PDF**: Formal reports, audit documentation

## Related Skills

- [Web App Security Audit](/skills/security-devops/web-app-security-audit/)
- [DevOps Expert](/skills/security-devops/devops-expert/)
- [Docker Expert](/skills/security-devops/docker-expert/)
- [Incident Postmortem Generator](/skills/security-devops/incident-postmortem-generator/)
- [Vendor Risk Assessment](/skills/industry/vendor-risk-assessment/)

## Troubleshooting

### Too Many Controls
If the checklist is overwhelming, specify a narrower scope:
- Focus on one framework (e.g., just OWASP Top 10)
- Specify risk level (medium/low apps need fewer controls)
- Request prioritized list (Critical/High only)

### Missing Tech-Specific Guidance
Provide more detail about your stack:
- Specific framework versions
- Cloud provider and services used
- Container/orchestration platform
- CI/CD toolchain

### Compliance Mapping Unclear
Ask for explicit mapping:
- "Map each control to PCI-DSS requirements"
- "Include NIST CSF function for each item"
- "Add HIPAA section references"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
