---
name: soc2-compliance-checker
version: 1.0.0
---

# SOC 2 Compliance Checker - Initialization

Prepare for SOC 2 Type I and Type II audits with comprehensive gap assessments, Trust Service Criteria mapping, control implementation guidance, evidence collection checklists, and production-ready policy templates. Designed for startups and SaaS companies navigating their first SOC 2 or improving an existing compliance program.

## Package Contents

```
soc2-compliance-checker/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Quick Start

### Claude Code Installation
```bash
# Copy skill to Claude Code skills directory
cp -r soc2-compliance-checker/ ~/.claude/skills/soc2-compliance-checker/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start a new conversation and describe your SOC 2 compliance needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audit_type}}` | `Type II` | Type I (point-in-time design) or Type II (operating effectiveness over 3-12 months) |
| `{{tsc_scope}}` | `Security, Availability, Confidentiality` | Trust Service Criteria in scope: Security (required), Availability, Processing Integrity, Confidentiality, Privacy |
| `{{company_type}}` | `B2B SaaS startup` | Company type and industry |
| `{{cloud_provider}}` | `AWS` | Primary cloud provider (AWS, Azure, GCP) |
| `{{team_size}}` | `15-50 employees` | Engineering and operations team size |
| `{{current_maturity}}` | `early-stage` | Security program maturity (early-stage, developing, established) |
| `{{audit_timeline}}` | `6 months` | Target date for audit readiness |
| `{{output_format}}` | `markdown` | Preferred output (markdown, json, spreadsheet, notion, jira) |

## Example Prompts

### First-Time SOC 2 for a SaaS Startup
```
We're a Series A SaaS startup with 30 employees running on AWS. Our largest
enterprise prospect requires SOC 2 Type II before signing a $500K contract.
We have basic security practices but no formal policies. Walk me through:
- Complete gap assessment against all five Trust Service Criteria
- Prioritized remediation roadmap
- Policy templates we need to create
- Evidence collection checklist
- Realistic timeline to audit-ready
```

### SOC 2 Type I Readiness Check
```
We've been implementing controls for SOC 2 Type I over the past 2 months.
Our scope is Security and Availability. We use AWS, Okta for identity,
Datadog for monitoring, and GitHub Actions for CI/CD. Can you:
- Walk through each CC criterion and assess our readiness
- Identify any remaining gaps that would cause exceptions
- Generate the evidence checklist for what we need to provide the auditor
- Review our access control policy draft for completeness
```

### Transitioning from Type I to Type II
```
We received our SOC 2 Type I report 3 months ago with no exceptions.
We want to begin our Type II observation period. Help me:
- Set up ongoing evidence collection procedures
- Create a compliance calendar for recurring controls
- Design monitoring dashboards for continuous compliance
- Prepare for the operational effectiveness testing the auditor will perform
```

### Gap Assessment for Specific Criteria
```
We're adding Confidentiality and Privacy to our SOC 2 scope for the next
audit cycle. We're a healthtech company processing PHI. Conduct a gap
assessment specifically for C Series and P Series criteria, considering
our existing Security controls are already in place.
```

## Trust Service Criteria Overview

| Category | Criteria | Required? | When to Include |
|----------|----------|-----------|-----------------|
| Security (CC) | CC1-CC9 | Yes (always) | Every SOC 2 report |
| Availability (A) | A1.1-A1.3 | No | SaaS with uptime SLAs, customer-facing systems |
| Processing Integrity (PI) | PI1.1-PI1.5 | No | Data processing, financial calculations, ETL pipelines |
| Confidentiality (C) | C1.1-C1.2 | No | Handling confidential business data, trade secrets |
| Privacy (P) | P1-P8 | No | Collecting/processing personal information |

## Type I vs Type II Quick Reference

| Aspect | Type I | Type II |
|--------|--------|---------|
| **Scope** | Control design at a point in time | Design + operating effectiveness over 3-12 months |
| **Evidence** | Policies, configurations | Policies + operational logs, review records, tickets |
| **Timeline** | 2-4 months from start | 6-12 months from start |
| **Cost** | $15-40K (auditor) | $25-60K (auditor) |
| **Best for** | First audit, quick customer requirement | Enterprise customers, regulated industries |

## Required Policies

| Policy | SOC 2 Mapping | Priority |
|--------|---------------|----------|
| Information Security Policy | CC1, CC5 | P0 |
| Access Control Policy | CC6 | P0 |
| Change Management Policy | CC8 | P0 |
| Incident Response Policy | CC7 | P0 |
| Risk Management Policy | CC3, CC9 | P1 |
| Data Classification Policy | C1, CC6 | P1 |
| Acceptable Use Policy | CC1, CC6 | P1 |
| Business Continuity / DR Policy | A1, CC7 | P1 |
| Vendor Management Policy | CC9 | P2 |
| Encryption & Key Management Policy | CC6 | P2 |
| Vulnerability Management Policy | CC7 | P2 |
| Security Awareness Training Policy | CC1 | P2 |

## Evidence Categories

| Category | Type I | Type II | Examples |
|----------|--------|---------|----------|
| Policies & Procedures | Required | Required | Approved policy docs, procedure runbooks |
| Configuration | Required | Required | IAM settings, encryption config, network rules |
| Operational | Not needed | Required | Access review logs, scan results, incident reports |
| Monitoring | Helpful | Required | SIEM dashboards, alert configs, compliance reports |

## Common Compliance Platforms

| Platform | Cost Range | Best For |
|----------|-----------|----------|
| Vanta | $10-50K/yr | Broad integrations, multiple frameworks |
| Drata | $10-40K/yr | Strong automation, mid-market |
| Secureframe | $10-30K/yr | Fast implementation, startups |
| Sprinto | $5-20K/yr | Budget-conscious startups |
| DIY (manual) | $0-5K | Technical teams with compliance experience |

## Related Skills

- [GDPR Compliance Auditor](/skills/legal/gdpr-compliance-auditor/)
- [Regulatory Compliance Readiness Auditor](/skills/industry/regulatory-compliance-readiness-auditor/)
- [Security Review Checklist Generator](/skills/security-devops/security-review-checklist-generator/)
- [Web App Security Audit](/skills/security-devops/web-app-security-audit/)
- [Privacy Policy Generator](/skills/industry/privacy-policy-generator/)

## Troubleshooting

### Customer Needs SOC 2 But We Have Nothing
Provide a SOC 2 Bridge Letter as interim measure, share security questionnaire responses, commit to a Type I timeline (2-4 months with focused effort), and consider compliance platforms for acceleration.

### Too Many Gaps, Small Team
Focus on P0/P1 items only, use compliance platform for automation, leverage cloud-native security features, hire a virtual CISO for 10-20 hours/month, and start with Type I to reduce initial scope.

### Auditor Found Exceptions
Ask auditor to define the exception clearly, implement immediate remediation with evidence, provide compensating controls, document management response, and create corrective action plan.

### Engineering Team Resistant
Frame controls as engineering best practices, automate within existing workflows, show how SOC 2 unlocks enterprise revenue, involve engineers in control design, and minimize process changes.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
