---
name: ssl-tls-configuration-advisor
version: 1.0.0
description: SSL/TLS configuration advisor for web servers, load balancers, and CDNs. Generates production-ready TLS configurations targeting A+ SSL Labs grades with cipher suite selection, certificate management, HSTS, OCSP stapling, and performance optimization.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive SSL/TLS configuration framework for securing HTTPS on web servers, load balancers, CDNs, and applications. It generates production-ready configurations based on Mozilla's SSL Configuration Generator and NIST SP 800-52 guidelines.

**What this skill enables:**
- Generate secure TLS configurations for Nginx, Apache, HAProxy, AWS ALB/CloudFront, and Caddy
- Select appropriate cipher suites across modern, intermediate, and legacy profiles
- Manage certificates (Let's Encrypt automation, key generation, chain verification, renewal)
- Configure HSTS with a gradual deployment strategy and HSTS preload
- Set up OCSP stapling for faster certificate validation
- Implement mutual TLS (mTLS) for service-to-service authentication
- Test and validate configurations with SSL Labs, testssl.sh, and OpenSSL
- Identify and fix common SSL/TLS misconfigurations
- Optimize TLS performance (session resumption, 0-RTT, HTTP/2 ALPN, ECDSA certificates)

**Time to initialize:** ~1 minute (prompt-only skill, no scripts required)

## Directory Structure

```
ssl-tls-configuration-advisor/
├── SKILL.md          # Main SSL/TLS configuration instructions and reference
└── INIT.md           # This initialization manifest
```

## Dependencies

This is a prompt-only skill with no hard dependencies. The skill references these tools that users may want to install for testing and certificate management:

**Certificate management:**
```bash
# Certbot (Let's Encrypt)
sudo apt install certbot python3-certbot-nginx    # Ubuntu/Debian
sudo dnf install certbot python3-certbot-nginx     # CentOS/RHEL

# acme.sh (alternative)
curl https://get.acme.sh | sh
```

**Testing tools:**
```bash
# testssl.sh (comprehensive local testing)
git clone --depth 1 https://github.com/drwetter/testssl.sh.git

# OpenSSL (usually pre-installed)
openssl version

# Online: SSL Labs - https://www.ssllabs.com/ssltest/
```

**DH parameter generation:**
```bash
openssl dhparam -out /etc/ssl/dhparam.pem 2048
```

## Files to Generate

This is a **prompt-only skill** - no scripts or additional files need to be generated. The complete SSL/TLS configuration framework is contained in SKILL.md.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
mkdir -p ~/.claude/skills/ssl-tls-configuration-advisor
cp SKILL.md INIT.md ~/.claude/skills/ssl-tls-configuration-advisor/
```

Then reference the skill in your Claude Code sessions when configuring SSL/TLS.

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as conversation context
4. Start your SSL/TLS configuration session

## Quick Start Examples

### Example 1: Full Server Configuration

```
User: I'm running Nginx as a reverse proxy for my Node.js API at api.example.com.
      I have a Let's Encrypt certificate but I'm not confident my TLS config is secure.
      I want to get an A+ on SSL Labs.

AI: I'll set up a secure intermediate TLS configuration for your Nginx server.
    Here's a complete configuration with TLS 1.2+1.3, strong AEAD ciphers,
    OCSP stapling, and HSTS...

    [Provides full nginx server block with ssl_protocols, ssl_ciphers,
     ssl_stapling, HSTS header, HTTP redirect, and testing commands]
```

### Example 2: Certificate Setup

```
User: I need to set up Let's Encrypt certificates for example.com and
      *.example.com with automatic renewal.

AI: For a wildcard certificate, you'll need DNS challenge authentication.
    Here's the setup with certbot...

    [Provides certbot commands for DNS challenge, renewal cron job,
     and post-renewal hook to reload the web server]
```

### Example 3: SSL Labs Audit Fix

```
User: My SSL Labs score is a B. The report says I have weak DH parameters
      and TLS 1.0 is enabled. How do I fix this?

AI: Two issues to fix for an A+ grade:

    1. Disable TLS 1.0 and 1.1 - they've been deprecated since RFC 8996...
    2. Generate strong DH parameters - your current ones are likely 1024-bit...

    [Provides specific config changes and commands for the user's server type]
```

### Example 4: mTLS for Microservices

```
User: I need to set up mutual TLS between my API gateway and backend services.
      We're using Nginx.

AI: I'll walk you through creating a private CA and configuring mTLS on Nginx.
    This ensures only authorized services can communicate with your backend...

    [Provides CA creation, client cert generation, Nginx ssl_verify_client
     configuration, and curl test commands]
```

## Compatibility

**Tested with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4 Turbo, GPT-4o)
- Gemini (Gemini Pro, Gemini Ultra)
- GitHub Copilot Chat
- Llama 3 and Mistral Large

**Works best with:** Claude and GPT-4 for generating complex multi-server configurations and troubleshooting specific SSL Labs findings.

## Variables

Customize these placeholders in the skill for your specific environment:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{server_type}}` | `nginx` | Web server or load balancer (nginx, apache, haproxy, caddy, aws-alb, cloudfront) |
| `{{compliance_level}}` | `intermediate` | Security profile: modern (TLS 1.3 only), intermediate (TLS 1.2+1.3), old (legacy) |
| `{{domain_name}}` | `example.com` | The domain name to configure SSL/TLS for |
| `{{certificate_type}}` | `DV` | Certificate type: DV, OV, EV, wildcard, or SAN |
| `{{use_case}}` | `web-server` | Deployment scenario: web-server, api, load-balancer, cdn, internal-service |

## Key Sections in SKILL.md

1. **TLS Protocol Version Guidance** - Current recommendations for enabling/disabling TLS versions, with TLS 1.3 advantages explained

2. **Cipher Suite Profiles** - Modern, intermediate, and legacy cipher suite sets with client compatibility information

3. **Server Configurations** - Complete, copy-paste-ready configurations for Nginx, Apache, HAProxy, AWS ALB/CloudFront, and Caddy with directive explanations

4. **Certificate Management** - Certificate types, key generation (RSA and ECDSA), Let's Encrypt automation with certbot and acme.sh, chain verification, and renewal monitoring

5. **Security Headers and OCSP** - HSTS deployment strategy, CAA DNS records, Certificate Transparency monitoring, and OCSP stapling setup

6. **Testing and Validation** - SSL Labs, testssl.sh, OpenSSL, and cURL commands for verifying configurations

7. **Mutual TLS (mTLS)** - Private CA creation, client certificate generation, and Nginx mTLS configuration

8. **Quick Audit Checklist** - Comprehensive checklist covering protocols, ciphers, certificates, headers, and performance

## Recommended Workflow

1. **Assess your needs** - Determine server type, compliance level, and use case
2. **Generate configuration** - Get a complete, tested configuration for your server
3. **Set up certificates** - Obtain and install certificates with automatic renewal
4. **Apply security headers** - Configure HSTS with gradual rollout
5. **Enable OCSP stapling** - Improve client certificate validation performance
6. **Test thoroughly** - Use SSL Labs for an A+ grade verification
7. **Monitor continuously** - Set up certificate expiry alerts and CT monitoring
8. **Document** - Record your configuration choices and rationale

## Additional Resources

- Mozilla SSL Configuration Generator: https://ssl-config.mozilla.org/
- SSL Labs Server Test: https://www.ssllabs.com/ssltest/
- NIST SP 800-52 Rev. 2: https://csrc.nist.gov/publications/detail/sp/800-52/rev-2/final
- Let's Encrypt Documentation: https://letsencrypt.org/docs/
- testssl.sh: https://github.com/drwetter/testssl.sh
- HSTS Preload: https://hstspreload.org/
- Certificate Transparency Search: https://crt.sh/

---

Downloaded from [Find Skill.ai](https://findskill.ai)
