---
name: terraform-module-reviewer
version: 1.0.0
---

# Initialization

Review Terraform configurations for security vulnerabilities, cost waste, best practice violations, and maintainability issues across AWS, Azure, and GCP. Covers 20+ review categories: hardcoded secrets detection, network security (security groups, NSGs, firewall rules), encryption at rest and in transit, IAM/RBAC privilege analysis, logging and monitoring gaps, public exposure risks, state management, module structure, variable validation, provider version pinning, resource tagging, lifecycle protections, data sources vs hardcoded values, count vs for_each usage, cost optimization (right-sizing, reservations, unused resources, storage classes), and common Terraform anti-patterns. All findings use a five-level severity scale (Critical, High, Medium, Low, Info) with concrete HCL code fixes.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Terraform review instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Review Terraform security** - Detect hardcoded secrets, overly permissive network rules, missing encryption, IAM privilege escalation paths, public exposure risks, and logging gaps
2. **Audit best practices** - Check state management (remote backend, locking, encryption), module structure, variable validation with type constraints, provider version pinning, resource tagging strategy, and lifecycle protections (prevent_destroy, deletion_protection)
3. **Optimize costs** - Identify over-provisioned resources, recommend reserved instances for always-on workloads, detect unused resources (unattached EIPs, detached volumes), and suggest storage class optimizations (GP3 over GP2, S3 lifecycle policies)
4. **Support multi-cloud** - Provider-specific checks for AWS (security groups, S3, RDS, IAM roles, CloudTrail), Azure (NSGs, storage accounts, Key Vault, managed identities), and GCP (firewall rules, Cloud SQL, service accounts, Workload Identity)
5. **Detect anti-patterns** - Flag mega-modules, god variables, unnecessary string interpolation, remote-exec provisioners, null_resource usage, workspace sprawl, and commented-out resources
6. **Map to compliance** - Reference tfsec/Checkov rule IDs and CIS Benchmark numbers for each finding
7. **Provide actionable fixes** - Every finding includes before/after HCL code examples, risk explanations, and documentation references
8. **Assess module readiness** - Evaluate whether a module meets the standard structure and documentation requirements for Terraform Registry publishing

## Review Categories

### Security (6 categories)
- **Secrets in code**: Hardcoded passwords, API keys, tokens, private keys in resource arguments, variable defaults, locals, outputs, providers, provisioners
- **Network security**: AWS security groups, Azure NSGs, GCP firewall rules -- overly permissive CIDR blocks, port ranges, protocols
- **Encryption**: At-rest and in-transit encryption for storage, databases, caches, queues, and key management
- **IAM/RBAC**: Overly broad policies, wildcard actions/resources, missing conditions, privilege escalation paths
- **Logging and monitoring**: CloudTrail, VPC Flow Logs, access logging, audit logging, retention policies
- **Public exposure**: Publicly accessible databases, open S3 buckets, unnecessary public IPs, missing WAF

### Best Practices (9 categories)
- **State management**: Remote backend, encryption, locking, environment isolation
- **Module structure**: Standard file organization, descriptions, types, documentation
- **Variable validation**: Type constraints, validation blocks, sensitive marking
- **Provider version pinning**: Pessimistic constraints, required_version
- **Resource tagging**: default_tags, consistent keys, cost allocation
- **Lifecycle rules**: prevent_destroy, deletion_protection, create_before_destroy, ignore_changes
- **Data sources vs hardcoded**: Dynamic lookups for AMIs, account IDs, regions, AZs
- **Count vs for_each**: Map-based iteration over index-based
- **Moved blocks**: Refactoring without destroy-and-recreate

### Cost Optimization (4 categories)
- **Right-sizing**: Instance types, database classes, storage provisioning
- **Reservations**: RI/Savings Plan candidates, Spot instance opportunities
- **Unused resources**: Unattached EIPs, detached volumes, orphaned security groups
- **Storage optimization**: S3 lifecycle policies, EBS type upgrades, tiering

### Anti-Patterns (12 patterns)
- Mega-modules, god variables, string interpolation abuse, nested ternaries, remote-exec provisioners, null_resource, state surgery workflows, workspace sprawl, missing terraform fmt, commented-out resources, hardcoded regions, missing .gitignore

## Severity Scale

| Level | Meaning | Action |
|-------|---------|--------|
| CRITICAL | Active vulnerability or data exposure | Fix before deploying |
| HIGH | Significant security or practice gap | Fix before production |
| MEDIUM | Best practice violation or moderate risk | Fix in next iteration |
| LOW | Minor improvement or code quality | Address when convenient |
| INFO | Optimization or recommendation | Consider for future |

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill references external tools (tfsec, Checkov, Sentinel, OPA) for context but does not require them to be installed. All review output is standalone analysis with HCL code fixes that can be applied directly.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r terraform-module-reviewer/ ~/.claude/skills/terraform-module-reviewer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Provide your Terraform .tf files for review

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{terraform_code}}` | `Paste your Terraform .tf files here` | The Terraform configuration code to review |
| `{{cloud_provider}}` | `aws` | Target cloud provider: aws, azure, or gcp |
| `{{module_purpose}}` | `Web application infrastructure with ALB, ECS, and RDS` | What the Terraform module provisions |
| `{{compliance_requirements}}` | `CIS Benchmarks, SOC 2` | Compliance frameworks to check against |
| `{{review_focus}}` | `all` | Review focus: security, cost, best-practices, or all |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
