---
name: web-app-security-audit
version: 1.0.0
description: Comprehensive web application security audit skill for non-developers covering OWASP Top 10, Firebase security, and free security tools
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive web application security audit framework designed for IT administrators, citizen developers, and non-security professionals. It covers OWASP Top 10 vulnerabilities, Firebase-specific security, dependency scanning, security headers, and pre-deployment checklists.

**What this skill enables:**
- Walk through OWASP Top 10 (2021) vulnerabilities with plain-English explanations
- Audit Firebase security rules for common misconfigurations
- Check for exposed secrets and XSS vulnerabilities in client-side code
- Scan dependencies for known vulnerabilities
- Configure essential security headers
- Complete a pre-deployment security checklist

**Time to initialize:** ~1 minute (prompt-only skill, no scripts required)

## Directory Structure

```
web-app-security-audit/
├── SKILL.md          # Main security audit instructions and checklists
└── INIT.md           # This initialization manifest
```

## Dependencies

This is a prompt-only skill with no dependencies. However, the skill references these free tools that users may want to install:

**Node.js/npm (for JavaScript projects):**
```bash
# Built-in vulnerability scanning
npm audit

# Snyk for enhanced scanning (free for open source)
npm install -g snyk
snyk auth
```

**Python (for Python projects):**
```bash
pip install pip-audit
pip install safety
```

**Firebase (for Firebase projects):**
```bash
npm install -g firebase-tools
firebase init emulators
```

## Files to Generate

This is a **prompt-only skill** - no scripts or additional files need to be generated. The complete security audit framework is contained in SKILL.md.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
mkdir -p ~/.claude/skills/web-app-security-audit
cp SKILL.md INIT.md ~/.claude/skills/web-app-security-audit/
```

Then reference the skill in your Claude Code sessions by mentioning web app security audits.

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as context for your conversation
4. Start your security audit conversation

## Quick Start Examples

### Example 1: Full Security Audit

```
User: I have a React app with Firebase backend deployed on Vercel.
      Can you walk me through a complete security audit?

AI: I'll guide you through a comprehensive security audit. Let's start
    with the most critical areas...

    First, let's check your Firebase Security Rules. Can you share
    your firestore.rules file? We need to verify:

    1. Test mode isn't deployed to production
    2. Users can only access their own data
    3. Write rules validate data structure

    [Continues through full OWASP Top 10 checklist...]
```

### Example 2: Quick Pre-Deployment Check

```
User: I'm about to deploy my app. What security checks should I do?

AI: Here's a critical pre-deployment checklist. Let's verify each item:

    CRITICAL (Must fix before launch):
    [ ] HTTPS is enforced
    [ ] No secrets in client-side code
    [ ] Firebase security rules are production-ready
    [ ] No high/critical vulnerabilities in dependencies

    Run: npm audit

    What does it show?
```

### Example 3: Specific Vulnerability Check

```
User: I'm worried about XSS attacks. How do I check for those?

AI: Let's do an XSS security check. First, let me ask:

    1. What frontend framework are you using? (React, Vue, vanilla JS?)
    2. Do you accept any user input that gets displayed?

    In the meantime, try entering this in your text fields:
    <script>alert('XSS')</script>

    If an alert box appears, you have an XSS vulnerability...
```

## Compatibility

**Tested with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4 Turbo)
- Gemini (Gemini Pro, Gemini Ultra)
- GitHub Copilot Chat

**Works best with:** Claude and GPT-4 for comprehensive security analysis and code review.

## Variables

Customize these placeholders in the skill for your specific situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_name}}` | `MyWebApp` | Name of the application being audited |
| `{{tech_stack}}` | `React, Node.js, Firebase` | Primary technologies in use |
| `{{deployment_platform}}` | `Firebase Hosting` | Where the app is deployed |

## Key Sections in SKILL.md

1. **OWASP Top 10 (2021) Audit Checklist** - Complete walkthrough of each vulnerability category with test procedures and remediation steps

2. **Firebase Security Audit** - Firestore rules, Auth security, and Storage security specific checks

3. **Security Headers Audit** - CSP, HSTS, and other essential headers with configuration examples for Vercel, Netlify, and Firebase

4. **Client-Side Security Audit** - Checking for exposed secrets and XSS vulnerabilities

5. **Dependency Security Audit** - Using npm audit, Snyk, and other tools

6. **Pre-Deployment Security Checklist** - Organized by priority (Critical, High, Medium)

7. **Free Security Tools Reference** - Quick reference table of recommended tools

## Recommended Workflow

1. **Start with the Pre-Deployment Checklist** if you're about to go live
2. **Work through OWASP Top 10** for a comprehensive audit
3. **Focus on Firebase Security** if using Firebase backend
4. **Check Security Headers** using free online tools
5. **Run Dependency Scans** to catch known vulnerabilities
6. **Document findings** and create tickets for remediation

## Additional Resources

- OWASP Top 10: https://owasp.org/Top10/
- Firebase Security Rules: https://firebase.google.com/docs/rules
- Security Headers: https://securityheaders.com
- Mozilla Observatory: https://observatory.mozilla.org
- Snyk: https://snyk.io

---

Downloaded from [Find Skill.ai](https://findskill.ai)
