---
name: zero-trust-architecture-advisor
version: 1.0.0
---

# Initialization

Guide organizations in designing and implementing Zero Trust Architecture based on NIST SP 800-207, the CISA Zero Trust Maturity Model v2.0, the DoD Zero Trust Reference Architecture, Google BeyondCorp principles, and the Forrester Zero Trust eXtended (ZTX) framework. Covers all five CISA pillars (Identity, Devices, Networks, Applications and Workloads, Data) across four maturity levels (Traditional, Initial, Advanced, Optimal), with phased implementation roadmaps, technology stack mapping, compliance alignment, policy engine design, and organizational change management.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Zero Trust advisory instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Assess Zero Trust maturity** - Evaluate an organization's current maturity across all five CISA Zero Trust pillars (Identity, Devices, Networks, Applications, Data) plus cross-cutting capabilities (Visibility, Automation, Governance), scoring each on a 1-4 scale (Traditional through Optimal) with gap analysis and prioritized findings
2. **Design NIST SP 800-207 architecture** - Map the organization's systems to the NIST Zero Trust Architecture including Policy Decision Point (PDP), Policy Enforcement Point (PEP), Policy Administrator (PA), and Policy Information Point (PIP) components with deployment model selection (Identity Governance, Micro-Segmentation, or Software Defined Perimeter)
3. **Implement Identity pillar** - Guide deployment of SSO, MFA (including phishing-resistant FIDO2/WebAuthn), conditional access policies, risk-based authentication, Privileged Access Management (PAM) with JIT elevation, Identity Governance and Administration (IGA), SCIM provisioning, and workload identity (SPIFFE/SPIRE) with vendor-specific configuration examples for Azure AD/Entra ID, Okta, and Ping Identity
4. **Implement Devices pillar** - Guide deployment of MDM (Intune, Jamf, Workspace ONE), device compliance policies, EDR/XDR (CrowdStrike, SentinelOne, Defender), device health attestation (TPM), BYOD containerization, and integration of device compliance into conditional access decisions
5. **Implement Networks pillar** - Guide deployment of micro-segmentation (Kubernetes NetworkPolicy, Calico, Illumio), service mesh with mTLS (Istio, Linkerd), Zero Trust Network Access (Zscaler ZPA, Cloudflare Access, Prisma Access), encrypted east-west traffic, Software Defined Perimeters, and SD-WAN with integrated security
6. **Implement Applications pillar** - Guide deployment of SASE architecture (ZTNA + SWG + CASB + FWaaS), application-aware access policies, API security gateways with OAuth 2.0/OIDC, container security (image scanning, runtime protection, admission control), and shadow IT discovery with SaaS governance
7. **Implement Data pillar** - Guide deployment of data classification frameworks (four-level: Public, Internal, Confidential, Restricted), Data Loss Prevention (DLP) across all channels, data access governance, sensitivity labeling, digital rights management, tokenization, encryption strategies, and Data Security Posture Management (DSPM)
8. **Design policy engines** - Create policy decision frameworks using Open Policy Agent (OPA) with Rego policies that evaluate identity, device compliance, network context, resource sensitivity, and behavioral risk signals to produce allow/deny/step-up decisions
9. **Plan migration from perimeter security** - Develop phased migration strategies from traditional perimeter-based security to Zero Trust, including parallel operation of VPN and ZTNA, application readiness classification (Cloud-Ready, Modernizable, Legacy), and incremental VPN decommission
10. **Align to compliance frameworks** - Map Zero Trust controls to Executive Order 14028, FedRAMP, CMMC 2.0, HIPAA, PCI-DSS v4.0, SOC 2, and ISO 27001:2022 with specific control references and evidence requirements
11. **Build implementation roadmap** - Create phased implementation plans (typically 18-36 months) with six phases: Assessment, Identity Foundation, Device Trust, Network Segmentation, Application Security, Data Protection, and Automation/Optimization, with quick wins for the first 30 days
12. **Define metrics and KPIs** - Establish a Zero Trust scorecard with pillar-specific KPIs (MFA coverage, device compliance rate, micro-segmentation coverage, ZTNA adoption, data classification progress) and risk reduction metrics (MTTD, MTTR, credential attack blocks, lateral movement detection)
13. **Recommend technology stack** - Provide vendor-specific recommendations for each pillar based on the organization's existing cloud provider, size, and requirements, with configuration examples for Azure, AWS, and GCP native Zero Trust capabilities
14. **Guide change management** - Address organizational readiness including executive sponsorship, employee communication (addressing surveillance concerns), training programs, pilot program design, and feedback channels

## Architecture Coverage

### Frameworks Referenced
- NIST SP 800-207: Zero Trust Architecture (abstract architecture, deployment models, trust algorithm)
- CISA Zero Trust Maturity Model v2.0 (five pillars, four maturity levels, cross-cutting capabilities)
- DoD Zero Trust Reference Architecture v2.0 (seven pillars, capability mappings)
- Google BeyondCorp (production Zero Trust implementation, Identity-Aware Proxy)
- Forrester Zero Trust eXtended (ZTX) Ecosystem (original framework, extended model)
- Microsoft Zero Trust architecture (Conditional Access, Defender, Purview, Sentinel)
- AWS Zero Trust on AWS (Verified Access, IAM Identity Center, Security Hub)

### CISA Pillars Detailed Coverage
- Identity: SSO, MFA, FIDO2/WebAuthn, conditional access, risk-based auth, PAM, JIT/JEA, IGA, SCIM, SPIFFE/SPIRE, passwordless, continuous access evaluation
- Devices: MDM (Intune, Jamf, Workspace ONE), EDR/XDR (CrowdStrike, SentinelOne, Defender), device compliance, TPM attestation, BYOD/MAM, device certificates, IoT/OT visibility
- Networks: micro-segmentation (K8s NetworkPolicy, Calico, Illumio), service mesh mTLS (Istio, Linkerd), ZTNA (Zscaler, Cloudflare, Prisma), SDP, SD-WAN, NDR, DNS security, encrypted east-west
- Applications: SASE (ZTNA+SWG+CASB+FWaaS), WAF, API gateway, CASB, container security, SBOM, supply chain, shadow IT discovery
- Data: classification, DLP, encryption (rest/transit/use), DRM/IRM, tokenization, sensitivity labels, data access governance, DSPM, data sovereignty

### Policy Engine
- Policy Decision Point (PDP) design
- Policy Enforcement Point (PEP) placement
- Policy Information Point (PIP) data sources
- Open Policy Agent (OPA) with Rego policy examples
- Multi-signal decision matrix (identity, device, location, risk, time)

### Cloud Platform Zero Trust
- Google BeyondCorp Enterprise: Identity-Aware Proxy (IAP), endpoint verification, context-aware access
- Microsoft Zero Trust: Entra ID Conditional Access, Intune, Defender XDR, Purview, Sentinel
- AWS Zero Trust: Verified Access, IAM Identity Center, VPC, Security Groups, PrivateLink, GuardDuty

### Compliance Mapping
- Executive Order 14028 (federal Zero Trust mandate)
- FedRAMP (AC, IA, SC control families)
- CMMC 2.0 (Level 2-3 control mappings)
- HIPAA (Technical Safeguards 164.312)
- PCI-DSS v4.0 (Requirements 1, 2, 7, 8, 10, 12)
- SOC 2 (CC6, CC7, CC8 Trust Services Criteria)
- ISO 27001:2022 (Annex A controls)

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides architecture guidance, configuration examples, and policy templates for Zero Trust components (identity providers, SASE platforms, service meshes, MDM, EDR, SIEM) but does not require any specific tools to be pre-installed.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r zero-trust-architecture-advisor/ ~/.claude/skills/zero-trust-architecture-advisor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_architecture}}` | `Traditional perimeter-based with VPN and firewalls` | Description of the current network and security architecture |
| `{{organization_size}}` | `Mid-size enterprise (500-5000 employees)` | Size of the organization (employees, locations, cloud footprint) |
| `{{maturity_level}}` | `traditional` | Current Zero Trust maturity level |
| `{{priority_pillar}}` | `Identity` | Which CISA Zero Trust pillar to prioritize first |
| `{{compliance_drivers}}` | `NIST 800-207, Executive Order 14028` | Compliance frameworks driving Zero Trust adoption |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
