---
name: affiliate-program-marketer
version: 1.0.0
---

# Affiliate Program Marketer - Initialization

Design, launch, and scale affiliate partnership programs with commission structures, recruitment strategies, fraud prevention, and performance optimization to drive measurable revenue growth.

## What This Skill Does

The Affiliate Program Marketer skill transforms your AI assistant into an expert affiliate program strategist that helps you:

- **Design Program Structures**: Create affiliate programs aligned with business objectives
- **Build Commission Architecture**: Develop competitive, sustainable compensation models
- **Craft Recruitment Messaging**: Generate personalized outreach that converts prospects
- **Generate Legal Documentation**: Create compliant affiliate agreements and policies
- **Develop Onboarding Programs**: Build training that accelerates affiliate success
- **Implement Fraud Prevention**: Detect and prevent affiliate fraud
- **Build Community**: Engage affiliates through authentic relationship building
- **Optimize Performance**: Track KPIs and refine program strategy

## Package Structure

```
affiliate-program-marketer/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None - this is a prompt-only skill. The entire skill is contained in `SKILL.md`.

## Installation

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r affiliate-program-marketer/ ~/.claude/skills/affiliate-program-marketer/
```

Then reference in your CLAUDE.md or use the skill directly.

### For ChatGPT, Gemini, Copilot, or Other AI Assistants

1. Open `SKILL.md`
2. Copy everything after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or as a system prompt
4. Begin using by describing your affiliate program needs

### For Claude Projects

1. Create a new project or open an existing one
2. Add `SKILL.md` to the project knowledge
3. The skill will be available in all project conversations

## Variables

Customize these variables when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{commission_rate_percentage}}` | `15` | Primary commission rate as percentage of sale value |
| `{{minimum_payout_threshold_usd}}` | `100` | Minimum earned commission before payout |
| `{{payment_frequency}}` | `monthly` | How often affiliates receive payouts |
| `{{cookie_duration_days}}` | `30` | Days a click is attributed to affiliate |
| `{{affiliate_tier_structure}}` | `tiered_percentage` | Commission model type |
| `{{fraud_detection_sensitivity}}` | `standard` | Fraud detection aggressiveness level |

## Quick Start Examples

**Example 1: Commission Structure Design**
```
I run a B2B SaaS with $99/month subscription and 40% gross margin.
Design a tiered commission structure for recruiting agencies and
YouTube creators. Include tier thresholds and bonus incentives.
```

**Example 2: Recruitment Outreach**
```
Create a personalized outreach email for a fitness influencer
(15K Instagram followers) who posts workout routines. Our product
is premium protein powder with 20% commission. Make it specific
to their content style.
```

**Example 3: Fraud Audit**
```
Review these conversion patterns: 87 total conversions, 6 flagged
with datacenter IPs and identical user agents. One affiliate has
15% chargeback rate. Generate a fraud assessment and response plan.
```

**Example 4: Onboarding Course**
```
Build a 5-module onboarding course for new affiliates joining our
e-commerce affiliate program. Include platform training, product
knowledge, promotional best practices, and compliance requirements.
```

## Best Practices

1. **Always start with program goals** - Define revenue targets and partner acquisition metrics
2. **Research competitor commissions** - Position competitively in your industry
3. **Invest in onboarding** - Poor onboarding is the #1 reason affiliates quit
4. **Monitor fraud continuously** - Bad actors compound quickly without detection
5. **Segment affiliates by tier** - Top 20% typically drive 80% of revenue
6. **Communicate regularly** - Silent programs lose affiliates
7. **Require FTC disclosures** - Non-compliance creates legal liability

## Related Skills

- **Channel Partner Recruitment** - B2B partner management for resellers
- **Cold Email Sequences** - Outreach templates for recruitment
- **Customer Analytics** - Analyze affiliate-referred customer behavior
- **Funnel Analysis** - Optimize conversion funnels
- **Email Marketing Automation** - Build affiliate engagement campaigns

## Version History

- **1.0.0** (2025-08-22): Initial release with full affiliate program management capabilities

---

Downloaded from [Find Skill.ai](https://findskill.ai)
