---
name: bad-client-fire-er
version: 1.0.0
---

# Initialization

Generate professional termination scripts and communication templates for ending difficult client relationships while protecting your reputation and minimizing legal risk.

## Structure

- `SKILL.md` - Main skill prompt with termination templates, workflows, and industry-specific language

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r bad-client-fire-er/ ~/.claude/skills/bad-client-fire-er/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{notice_period_days}}` | `30` | Days between termination notice and effective date (30, 60, or 90) |
| `{{termination_reason}}` | `fit_based` | Category: non_payment, scope_creep, policy_violation, capacity_constraint, behavior_disrespect, contract_breach |
| `{{communication_channel}}` | `formal_letter` | Delivery method: formal_letter (email + certified mail), email_only, phone_call |
| `{{transition_support_level}}` | `full_handover` | Post-termination assistance: full_handover, documentation_only, minimal |
| `{{industry_context}}` | `general_services` | Industry for language adjustment: msp_it, freelance_agency, professional_services, healthcare |
| `{{client_payment_status}}` | `current` | Payment history: current, past_due, never_paid |

## Quick Start

1. Tell the AI about your situation:
   - What industry are you in?
   - What has the client done (non-payment, scope creep, disrespect, etc.)?
   - Do you have a written contract with notice requirements?
   - What outcome do you want (immediate exit, gradual transition, warning)?

2. The AI will generate:
   - Recommended termination approach
   - Timeline with specific dates
   - Professional termination letter/email
   - Scripts for handling pushback
   - Documentation checklist

## Example Usage

```
I need a professional termination email for a freelance client who hasn't
paid invoices for 90+ days. They keep asking for "just one more small project"
while owing $4,500. I want to be firm but not burn bridges since they're in
my industry. Give me a script I can send today that halts work immediately
but offers transition support.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
