---
name: client-boundary-setter
version: 1.0.0
description: Set and enforce professional boundaries with freelance clients
author: FindSkill.ai
license: MIT
---

# Client Boundary Setter — Initialization

## Overview

This is a prompt-only skill for freelancers who need to set professional boundaries with clients. It provides ready-to-send scripts, contract templates, and a prevention framework.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with 7 boundary situations and contract templates
- `INIT.md` — This initialization guide

## Directory Structure

```
client-boundary-setter/
├── SKILL.md    # Main skill with scripts and templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Describe the client boundary situation you're facing

### ChatGPT / Gemini / Copilot
Same process — paste and describe the situation.

## Core Capabilities

1. **7 Boundary Situation Scripts** — Scope creep, after-hours, late payment, deadlines, calls, firing, revisions
2. **Multiple Tone Options** — Diplomatic to very firm for each situation
3. **Prevention Framework** — 4-layer boundary stack (contract, onboarding, PM, enforcement)
4. **Contract Clause Templates** — Scope, revisions, payment, communication, termination, kill fee
5. **Tone Calibration** — 5-level spectrum matched to relationship and severity
6. **Confidence Framework** — Reframing boundaries as client benefits

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `situation` | `` | The boundary situation you're dealing with |
| `client_relationship` | `long-term client` | How important this client is |
| `tone` | `firm but friendly` | The tone you want |

## Usage Examples

### Example 1: Scope Creep

**User:** "Client keeps adding features to a fixed-price website project."

**AI Response:** Provides a diplomatic scope creep script with specific change request pricing and a contract clause for future projects.

### Example 2: Weekend Texting

**User:** "Biggest client texts me on Saturdays expecting same-day responses."

**AI Response:** Provides a reactive boundary-setting message that protects the weekend while keeping the relationship warm, plus a proactive availability template for future clients.

### Example 3: Late Payment

**User:** "Invoice is 3 weeks late and I need to follow up without being rude."

**AI Response:** Provides a 3-stage escalation sequence: friendly reminder, firm follow-up with late fee reference, and work pause notice.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Afraid to lose the client | Read the Confidence Framework — good clients respect boundaries |
| Don't have a contract | Start with the onboarding email template as informal agreement |
| Client ignores my boundary | Escalate tone level and document the pattern |
| Not sure what tone to use | Start with "firm but friendly" — you can escalate later |
| Client is also a friend | Extra important to set boundaries early — friendship survives professionalism |

## Best Practices

1. **Set boundaries early** — day 1 is easier than month 3
2. **Put it in writing** — verbal agreements are forgotten
3. **Be consistent** — enforcing sometimes but not always undermines the boundary
4. **Frame as mutual benefit** — "This helps me do better work for you"
5. **Have a contract** — even a simple scope document protects both parties
6. **Don't apologize for professionalism** — you're running a business

---
Downloaded from [Find Skill.ai](https://findskill.ai)
