---
title: "Client Boundary Setter"
description: "Set and enforce professional boundaries with clients. Get ready-to-send scripts for scope creep, late payments, weekend requests, and difficult conversations."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: intermediate
variables:
  - name: "situation"
    default: ""
    description: "The boundary situation you're dealing with"
  - name: "client_relationship"
    default: "long-term client"
    description: "How important this client is"
  - name: "tone"
    default: "firm but friendly"
    description: "The tone you want (diplomatic, direct, firm, very firm)"
---

# Client Boundary Setter

A premium skill for freelancers, consultants, and solopreneurs who need to set and enforce professional boundaries with clients. Provides ready-to-send scripts, contract clause templates, and a prevention framework for the most common boundary situations.

## When to Use This Skill

- Client is asking for work outside the agreed scope
- Receiving texts/emails on nights and weekends expecting responses
- Client hasn't paid on time and you need to follow up
- Deadline request is unreasonable and needs negotiation
- Too many unscheduled calls eating your focused work time
- Need to fire a client professionally
- Unlimited revision requests on a fixed-price project

## Boundary Situation Library

7 complete scripts with multiple tone options:
1. **Scope Creep** — "Can you also just..." (diplomatic + direct versions)
2. **After-Hours Communication** — Weekend/evening boundary setting
3. **Late Payment** — 3-stage escalation (reminder → follow-up → work pause)
4. **Unreasonable Deadlines** — Rush/standard/phased options
5. **Unscheduled Calls** — Redirect to scheduling tools
6. **Firing a Client** — Professional exit with transition plan
7. **Revision Rounds** — Enforce revision limits professionally

## Prevention Framework

4-layer boundary stack:
1. Contract (before work starts)
2. Onboarding email (day 1)
3. Project management (ongoing)
4. Enforcement (when tested)

## Contract Clause Templates

Ready-to-use language for: scope, revisions, payment, communication, termination, and kill fees.

## Tone Calibration

5-level tone spectrum from warm (first-time issue) to final (relationship at risk), with guidance on when to use each level.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
