---
name: founder-dm-slider
version: 1.0.0
---

# Founder DM Slider - Initialization

Transform cold outreach into authentic founder relationships with 25%+ response rates. This skill provides systematic frameworks for LinkedIn, Twitter, and email DMs that get replies instead of deletes.

## Package Contents

```
founder-dm-slider/
├── SKILL.md   # Main skill prompt (copy to AI assistant)
└── INIT.md    # This file (setup instructions)
```

## Structure

- `SKILL.md` - Complete founder outreach system including:
  - 5 detailed workflows (LinkedIn, Twitter, Email, Community, Warm Intro)
  - 3-sentence message framework
  - Platform-specific timing guides
  - Personalization at scale strategy
  - Follow-up sequences
  - Troubleshooting guide
  - Example messages for common scenarios

## Files to Generate

None required. This is a prompt-only skill that works directly with any AI assistant.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r founder-dm-slider/ ~/.claude/skills/founder-dm-slider/

# Add to your .claude/settings.json if you want auto-loading
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md` in any text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or first message
4. Start with: "I want to reach out to [type of founders] on [platform] about [your goal]"

### Quick Start Prompts

**LinkedIn Sequence:**
```
I want to reach out to 20 B2B SaaS founders on LinkedIn who recently raised Series A.
I'm a fractional CMO and want to offer strategic advice.
Help me create a 3-touch sequence.
```

**Twitter DM:**
```
I found a climate tech founder on Twitter who just posted about scaling challenges.
I have relevant experience.
Help me craft a DM that doesn't sound like spam.
```

**Email Campaign:**
```
I'm reaching out to fintech founders via email.
I have a product that solves payment reconciliation.
Create a 4-email sequence with subject lines.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `platform_primary` | `linkedin` | Primary platform: linkedin, twitter, or email |
| `founder_segment` | `SaaS founders who recently raised Series A` | Target founder description |
| `outreach_volume` | `30-50 per week` | Number of outreach messages |
| `value_offer` | `relevant insight or resource` | What you offer upfront |
| `response_goal` | `start a conversation` | Desired outcome |
| `tone_style` | `conversational professional` | Message tone |

## Key Frameworks

### The 3-Sentence Rule
Every initial message must be exactly 3 sentences:
1. **Recognition** - Specific observation about their work
2. **Relevance** - Why you're reaching out
3. **Soft CTA** - A question, not a demand

### Timing Guide
- **LinkedIn:** Tuesday-Thursday, 8:30 AM - 1:00 PM
- **Twitter:** Tuesday-Wednesday, 9 AM - 11 AM
- **Email:** Tuesday-Wednesday, 8 AM - 10 AM

### Volume Limits
- Testing: 30-50/week
- Active: 70-100/week
- Scaling: 150-200/week
- Danger zone: 300+/week

## Expected Results

| Metric | Generic Outreach | This Framework |
|--------|------------------|----------------|
| Response rate | 2-5% | 25-35% |
| After engagement | 10-15% | 40-50% |
| Warm intro | 30-40% | 50-70% |

## Troubleshooting

**0% response rate?**
- Messages over 3 sentences? Shorten.
- Bad timing? Shift to Tuesday-Thursday mornings.
- Profile not credible? Optimize first.

**Getting flagged as spam?**
- Stop outreach for 48-72 hours
- Reduce volume by 50%
- Complete account warm-up protocol

## Related Skills

- [LinkedIn Connection Messages](/skills/productivity/linkedin-connection-messages/)
- [LinkedIn B2B Lead Generation](/skills/productivity/linkedin-b2b-lead-generation/)
- [Cold Email Outreach Pro](/skills/productivity/cold-email-outreach/)
- [Sales Copywriting](/skills/ai-creative/sales-copywriting/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
