---
name: freelance-portfolio-reviewer
version: 1.0.0
---

# Freelance Portfolio Reviewer - Initialization

Expert-level portfolio critique skill that provides structured feedback, case study analysis, and actionable improvement recommendations for designers, developers, writers, and creative professionals.

## Skill Overview

This skill transforms your AI assistant into an experienced portfolio critic with:

- **5-Category Evaluation Framework**: Structure, Visual Design, Case Studies, Relevance, Communication
- **6-Part Case Study Analysis**: Problem, Research, Process, Solution, Results, Lessons
- **Discipline-Specific Criteria**: UX/UI, graphic design, web development, copywriting
- **20+ Common Mistake Detection**: Identifies and fixes portfolio errors
- **Multiple Output Formats**: Detailed reports, executive summaries, action checklists

## Package Structure

```
freelance-portfolio-reviewer/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
├── INIT.md       # This initialization file
└── index.md      # Hugo page file (website only)
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r freelance-portfolio-reviewer/ ~/.claude/skills/freelance-portfolio-reviewer/
```

### Claude Desktop / ChatGPT / Other AI Assistants

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start using by sharing your portfolio URL or describing your projects

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `review_depth` | `comprehensive` | Scope: quick, standard, or comprehensive |
| `discipline_focus` | `all` | Field: ux_ui, graphic_design, web_development, copywriting, video, illustration, or all |
| `feedback_tone` | `constructive` | Style: constructive, direct, encouraging, or executive_summary |
| `audience_context` | `potential_client` | Target viewer: potential_client, hiring_manager, art_director, investor, peer_creative |

## Example Usage

### Quick Portfolio Review

```
Review my portfolio at [URL]. I'm a UX designer targeting tech startups.
Give me a quick overview with the top 3 things to fix.
```

### Comprehensive Audit

```
Do a full audit of my portfolio. I'm a freelance web developer with 3 years
of experience trying to attract higher-paying clients. Focus on case study
quality and how I present my process.

Use direct tone - I can handle honest feedback.
```

### Case Study Critique

```
Review this specific case study from my portfolio:
[Project description or screenshots]

Tell me if it follows the 6-part case study framework and what's missing.
```

### Comparative Analysis

```
Compare these two portfolio approaches:
- Portfolio A: [description]
- Portfolio B: [description]

Which is stronger for attracting enterprise clients?
```

## Evaluation Framework Summary

The skill evaluates portfolios across 5 weighted categories:

| Category | Weight | What It Measures |
|----------|--------|------------------|
| Structure & Organization | 20% | Navigation, project count, load speed, mobile |
| Visual Design | 20% | Consistency, quality, accessibility |
| Case Study Quality | 30% | Process documentation, results, storytelling |
| Relevance & Targeting | 15% | Market fit, specialization, recency |
| Communication | 15% | Writing quality, About page, CTAs |

## Key Features

### The 6-Part Case Study Framework

1. **Problem Statement** - Business/user problem clarity
2. **Research & Discovery** - User research evidence
3. **Process Documentation** - Iterations and decisions
4. **Solution Presentation** - Final deliverables quality
5. **Results & Impact** - Metrics and testimonials
6. **Lessons Learned** - Reflection and growth

### Discipline-Specific Criteria

- **UX/UI**: User research, wireframes, accessibility, testing
- **Graphic Design**: Brand strategy, versatility, typography
- **Web Development**: Code quality, GitHub, performance
- **Copywriting**: Results metrics, voice versatility, strategy

### Output Formats

- **Detailed Report**: Full analysis with category scores and action plan
- **Executive Summary**: Quick overview with top 3 strengths and fixes
- **Action Checklist**: Prioritized implementation tasks

## Post-Installation Verification

Test the skill by asking:

```
I need a portfolio review. What information do you need from me to get started?
```

The AI should:
1. Ask about your discipline (design, development, writing, etc.)
2. Request portfolio URL or project descriptions
3. Ask about target audience (clients, employers, etc.)
4. Clarify desired feedback depth and tone

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Generic feedback | Provide more specific project details |
| Missing criteria | Ensure full SKILL.md content was copied |
| Wrong discipline focus | Specify your field in the prompt |
| Too harsh/soft | Adjust `feedback_tone` variable |

## Related Skills

- **Portfolio Fluff Cutter** - Identify weak projects to remove
- **Personal Brand Clarity Session** - Define your positioning
- **Testimonial Extractor** - Collect client social proof
- **Niche Down Generator** - Focus your specialty

---
Downloaded from [Find Skill.ai](https://findskill.ai)
