---
name: freelance-rate-calculator
version: 1.0.0
---

# Initialization

Calculate optimal freelance hourly and project rates using three methodologies: cost-based (your floor), market-based (your benchmark), and value-based (your ceiling). Overcome pricing anxiety with data-driven confidence.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with rate calculation instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r freelance-rate-calculator/ ~/.claude/skills/freelance-rate-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Usage Example

After loading the skill, try:

```
I'm a freelance graphic designer with 4 years of experience. My monthly expenses are about $4,500 and I want to make $85,000 this year. I can realistically work about 30 hours per week, but only 20 are billable. I've been charging $45/hour but feel like I'm undercharging compared to others in Austin, TX. Help me calculate what I should actually be charging.
```

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_annual_income_goal}}` | `$100,000` | Target annual income before taxes |
| `{{my_monthly_expenses}}` | `$5,000` | Total monthly business and personal expenses |
| `{{my_billable_hours_per_week}}` | `25` | Hours realistically billable to clients each week |
| `{{my_industry}}` | `web development` | Freelance industry or specialty |
| `{{my_experience_level}}` | `intermediate` | Experience level (beginner, intermediate, expert) |

## Key Features

### Three Pricing Methodologies
1. **Cost-Based Pricing** - Calculate your Minimum Acceptable Rate (MAR) based on expenses, taxes, and profit margin
2. **Market-Based Pricing** - Compare against industry benchmarks and apply experience/location adjustments
3. **Value-Based Pricing** - Price based on 10-25% of value delivered to clients

### Conversion Formulas
- Hourly to project rate conversion with buffer multipliers
- Tiered pricing structure recommendations
- Retainer rate calculations

### Confidence Building
- Rate increase scripts for existing clients
- Objection handling responses for common pushback
- Pricing psychology techniques

## Output Format

The skill provides a comprehensive rate summary including:
- Cost-based rate (your floor)
- Market-based rate (your benchmark)
- Value-based rate (your ceiling)
- Recommended hourly and project rates
- Retainer pricing options

## Related Skills

- `client-proposal-generator` - Create professional proposals using your calculated rates
- `invoice-chaser` - Get paid on time after quoting your rates
- `pricing-confidence-booster` - Advanced value-based pricing psychology (premium)
- `scope-creep-blocker` - Protect your rates from scope expansion (premium)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
