---
name: freelancer-vetting-framework
version: 1.0.0
---

# Freelancer Vetting Framework - Initialization

A comprehensive system for evaluating freelancers before hiring, including portfolio rubrics, reference check scripts, rate benchmarking, red flag detection, and paid test project design.

## What This Skill Does

This skill transforms you into a freelancer hiring consultant that helps systematically vet contractors across 7 core capabilities:

1. **Portfolio Assessment** - 10-point rubric for evaluating work samples
2. **Reference Verification** - Scripts for contacting past clients
3. **Rate Benchmarking** - Market comparison and value analysis
4. **Communication Assessment** - Evaluating professionalism signals
5. **Skill Testing** - Designing paid test assignments
6. **Red Flag Detection** - Identifying warning signs and risks
7. **Performance Monitoring** - Ongoing relationship management

## Structure

```
freelancer-vetting-framework/
├── SKILL.md     # Main skill prompt (copy this to use)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r freelancer-vetting-framework/ ~/.claude/skills/freelancer-vetting-framework/
```

Then reference in your `.claude/settings.json`:

```json
{
  "skills": {
    "freelancer-vetting-framework": "~/.claude/skills/freelancer-vetting-framework/SKILL.md"
  }
}
```

### For ChatGPT / Gemini / Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation or custom GPT/Gem instructions

### For Custom AI Applications

Import the skill content from `SKILL.md` as a system prompt or inject it as context at conversation start.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assessment_focus_area}}` | `general` | Skill focus: general, technical, creative, content, project_management, specialized_domain |
| `{{experience_level_required}}` | `mid` | Experience tier: junior (0-2 yrs), mid (3-7 yrs), senior (8+ yrs), expert |
| `{{budget_range_min}}` | `$30` | Minimum acceptable rate |
| `{{budget_range_max}}` | `$150` | Maximum acceptable rate |
| `{{project_complexity_level}}` | `medium` | Complexity: low, medium, high, expert_only |
| `{{vetting_timeline_days}}` | `7` | Days available for vetting (impacts depth) |

## Quick Start Examples

### Fast-Track Developer Vetting
```
I need to hire a React developer urgently for a 2-week project. Budget is $60-80/hour.
I've received 5 proposals. Help me screen them quickly with portfolio review,
rate verification, and a 20-minute interview guide.
```

### Comprehensive Design Evaluation
```
I'm hiring a senior UI/UX designer for a 6-month product redesign. Budget up to $120/hour.
Create a full vetting process: portfolio rubric, reference check scripts,
paid test project design, and candidate comparison matrix.
```

### Red Flag Investigation
```
A freelancer's profile claims 10 years experience but their portfolio only shows
work from 2021. Their rate is 40% below market. They're pushing for off-platform
payment. Help me investigate these red flags and decide whether to proceed.
```

### Rate Negotiation
```
I received quotes from 3 content writers: $4,000/month flat, $60/hour, and
$5,500/month. All have similar portfolios. Help me evaluate which rate is
most reasonable and prepare negotiation talking points.
```

## Workflows Available

| Workflow | Duration | Use When |
|----------|----------|----------|
| Fast-Track Vetting | 1-2 days | Urgent hire, lower stakes |
| Comprehensive Evaluation | 1-2 weeks | Critical hire, long-term engagement |
| Rate Verification | 3-5 days | Evaluating quotes, budget planning |
| Red Flag Investigation | 1-3 days | Suspicious patterns, risk mitigation |
| Performance Monitoring | Ongoing | Managing active freelance relationships |

## Key Outputs

- **Portfolio Scoring Matrix** - 10-criterion evaluation (100-point scale)
- **Reference Check Scripts** - Verification, performance, reliability questions
- **Rate Analysis Report** - Market benchmarks, value assessment, recommendations
- **Red Flag Assessment** - Severity ratings, investigation findings, risk score
- **Candidate Comparison Matrix** - Weighted scoring across top candidates
- **Vetting Summary Report** - Final recommendation with justification

## Platform-Specific Features

### Upwork Signals
- Job Success Score interpretation (90%+ excellent, <70% investigate)
- Talent badge meanings (Top Rated, Rising Talent, Expert-Vetted)
- Hours worked and earnings history analysis

### Fiverr Signals
- Seller level progression indicators
- Response time and completion rate analysis
- Review pattern evaluation

### General Platform Signals
- Verification badge significance
- Profile completeness correlation
- Repeat client percentage meaning

## Research Sources

This skill was developed using insights from:
- Index.dev portfolio evaluation guide
- Thirdwork vetted freelancer methodology
- Xolo 6-step vetting framework
- Forbes freelance talent vetting tips
- Upwork talent screening documentation
- Industry reference checking best practices

---
Downloaded from [Find Skill.ai](https://findskill.ai)
