---
name: grant-subsidy-finder
version: 1.0.0
---

# Grant & Subsidy Finder - Initialization

Identify legitimate government grants, tax credits, and subsidies for your business. Includes eligibility matching, scam detection, SAM.gov guidance, and application strategy.

## Structure

```
grant-subsidy-finder/
├── SKILL.md     # Main skill prompt (copy into AI assistant)
└── INIT.md      # This file - setup instructions
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r grant-subsidy-finder/ ~/.claude/skills/grant-subsidy-finder/
```

Then reference in your CLAUDE.md:
```markdown
## Available Skills
- `grant-subsidy-finder` - Find grants, tax credits, and subsidies for your business
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into the "Instructions" field when creating a Custom GPT
4. Name: "Grant & Subsidy Finder"
5. Description: "Find legitimate grants, tax credits, and subsidies for your business"

### Claude.ai / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Start a new conversation
4. Paste the skill content as your first message
5. Follow with your specific grant search request

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_zip_code}}` | `None specified` | Filters location-based programs like HUBZone and rural grants |
| `{{naics_code}}` | `General business` | Industry classification for eligibility matching |
| `{{owner_demographics}}` | `Not specified` | Array of certifications (veteran, woman-owned, minority) |
| `{{funding_amount_min}}` | `5000` | Minimum grant size to surface in results |
| `{{match_tolerance_pct}}` | `0` | Maximum self-funding percentage acceptable |
| `{{search_deadline_days}}` | `90` | Opportunities closing within this many days |

## Example Usage

**Basic Grant Search:**
```
I run a woman-owned bakery in ZIP 43001 with 5 employees and $350K annual revenue.
I need $20K-$50K for commercial equipment. Find me legitimate grants I might
qualify for, check if I need SAM registration, and flag any scam red flags.
```

**Scam Verification:**
```
I received an email from "Federal Grant Federation" saying I'm pre-approved for
$50,000. Is this legitimate? What should I check?
```

**SBIR/STTR Search:**
```
We're a tech startup developing an AI-powered medical device. Walk me through
the SBIR Phase I application process - from SAM registration to contacting the
NIH Program Officer. We have a 3-month deadline.
```

**Tax Credit Assessment:**
```
I have a software company with 15 employees. What tax credits might I be
missing? Particularly interested in R&D credits and hiring incentives.
```

## Key Resources

- **Grants.gov**: https://grants.gov - Federal grant database
- **SAM.gov**: https://sam.gov - Required registration for federal grants
- **SBIR.gov**: https://sbir.gov - R&D grants for small businesses
- **USASpending.gov**: https://usaspending.gov - Research past award winners

## What This Skill Does

1. **Eligibility Matching** - Filters opportunities by NAICS code, location, demographics
2. **Scam Detection** - Verifies legitimacy against official sources
3. **SAM.gov Guidance** - Walks through registration requirements
4. **Deadline Tracking** - Surfaces opportunities within your timeline
5. **Application Strategy** - Helps align proposals to NOFO priorities
6. **Tax Credit Identification** - Finds R&D, WOTC, and state credits
7. **Success Benchmarking** - Analyzes past winners on USASpending.gov

## Troubleshooting

**"I can't find grants for my industry"**
- Try broader search terms
- Check state-level programs
- Consider tax credits as an alternative

**"SAM.gov registration is delayed"**
- Call Federal Service Desk: 866-606-8220
- Verify TIN matches IRS records exactly
- Start 45+ days before any deadline

**"I received a suspicious grant offer"**
- Check if program exists on Grants.gov
- Verify sender uses .gov email
- NEVER pay upfront fees

---
Downloaded from [Find Skill.ai](https://findskill.ai)
