---
name: invoice-chaser
version: 1.0.0
---

# Invoice Chaser - Initialization

Automated dunning system that pursues unpaid invoices through professionally escalating email sequences from polite reminders to legal threats, maximizing collections while maintaining FDCPA compliance.

## What This Skill Does

Invoice Chaser is an expert accounts receivable assistant that helps freelancers, small businesses, and enterprises recover unpaid invoices through strategically escalating communication sequences. It generates professional email templates for each stage of the collection process, from friendly reminders through formal demand letters, while ensuring legal compliance with FDCPA, CFPB, and international debt collection regulations.

## Structure

```
invoice-chaser/
├── SKILL.md     # Main skill prompt (self-contained)
└── INIT.md      # This initialization file
```

## Files to Generate

None - This is a prompt-only skill. All functionality is contained within `SKILL.md`.

## Post-Installation Steps

### For Claude Code (Recommended)

```bash
# Option 1: Copy to Claude Code skills directory
cp -r invoice-chaser/ ~/.claude/skills/invoice-chaser/

# Option 2: Add to project-specific skills
cp -r invoice-chaser/ .claude/skills/invoice-chaser/
```

Then invoke with: "Use the invoice-chaser skill to help me collect on an overdue invoice"

### For ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or at the start of conversation
4. Follow up with your invoice details

### For Claude.ai (Web)

1. Start a new conversation
2. Copy the full content of `SKILL.md` (excluding frontmatter)
3. Paste and send as your first message
4. Provide your invoice details in the next message

### For Gemini

1. Open `SKILL.md`
2. Copy all content after frontmatter
3. Paste into Gemini conversation
4. Describe your unpaid invoice situation

### For GitHub Copilot

1. Add `SKILL.md` to your project's `.github/copilot-instructions.md`
2. Or paste into Copilot Chat as context
3. Ask for collection email templates

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `payment_terms_days` | `30` | Days until payment due (Net 30, Net 60, etc.) |
| `late_fee_percentage` | `1.5` | Monthly late fee percentage applied after due date |
| `escalation_interval` | `14` | Days between escalation stages in the dunning sequence |
| `collection_threshold_days` | `90` | Days overdue before collection agency referral considered |
| `jurisdiction` | `US` | Legal jurisdiction for compliance (US, UK, EU, AU) |
| `relationship_priority` | `balanced` | Preservation vs. collection focus (high, balanced, low) |

## Quick Start Examples

### Example 1: Freelancer with Overdue Invoice

```
I have an unpaid invoice #INV-2024-156 for $3,500 from a marketing agency.
It was due December 15th and I sent one reminder on December 22nd with no response.
We've worked together twice before. Create a full escalation sequence
with 1.5% monthly late fees. Client is in California.
```

### Example 2: B2B High-Value Collection

```
Our company is owed $45,000 from a corporate client (Invoice #B2B-9923).
Net 30 terms, now 60 days overdue. AP contact hasn't responded to 3 emails.
We need to escalate but don't want to damage the relationship entirely.
What's the next step and can you draft an email to their controller?
```

### Example 3: Settlement Negotiation

```
A client owes us $8,000 but says they can only pay $5,000 total due to
financial difficulties. Should we accept this settlement? If yes,
draft a formal settlement agreement that protects us legally.
```

### Example 4: Legal Escalation

```
I've exhausted all collection attempts on a $12,000 invoice that's now
120 days overdue. The client is in Texas. Draft a formal demand letter
and explain my small claims options.
```

## Core Capabilities

1. **Dunning Sequence Generation**: 7-stage escalation from friendly to legal
2. **Email Template Creation**: Professional templates for each collection stage
3. **Payment Plan Negotiation**: Settlement offers and installment agreements
4. **Legal Document Drafting**: Demand letters, settlement agreements, court prep
5. **Compliance Checking**: FDCPA, CFPB, GDPR, CAN-SPAM compliance
6. **AR Metrics Tracking**: DSO calculation, aging analysis, write-off guidance
7. **Multi-Channel Strategy**: Email, phone, mail, certified delivery advice

## Key Concepts Covered

- Dunning Process & Escalation Psychology
- Days Sales Outstanding (DSO) Optimization
- FDCPA Compliance Requirements
- Late Fee Calculation (US/UK/EU)
- Letter of Demand Requirements
- Small Claims Court Procedures
- Settlement Agreement Drafting
- Collection Agency Handoff
- Statute of Limitations by Jurisdiction

## Related Skills

- **Invoice Generator**: Create invoices before you need to chase them
- **Bill Negotiation Scripts**: Templates for payment negotiations
- **Cold Email Outreach**: Professional email sequence strategies
- **Bad Client Fire-er**: When to cut ties with non-paying clients
- **Freelance Rate Calculator**: Set rates accounting for collection delays

## Verification

To verify installation, ask the AI:

> "I have an unpaid invoice. Can you help me create a collection email sequence?"

The AI should immediately ask for:
1. Invoice details (number, amount, due date)
2. Client type and relationship
3. Previous contact attempts
4. Payment terms
5. Relationship priority

If it provides these questions, the skill is working correctly.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
