---
name: local-business-google-profile-optimizer
version: 1.0.0
description: Optimize Google Business Profile for local SEO — setup, categories, posts, photos, reviews, Q&A, ranking strategies
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides complete Google Business Profile optimization expertise for local businesses — profile setup, category selection, review management, posting schedules, photo strategy, Q&A seeding, and weekly maintenance routines.

**Time to initialize**: ~3 minutes

## Directory Structure

```
local-business-google-profile-optimizer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with any AI assistant.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Share your business name, type, and location
2. Describe your current Google Business Profile status
3. State your goals (foot traffic, calls, reviews, visibility)
4. Get a complete optimization checklist with action items

### Key Principles

- Primary category is the #1 ranking factor — choose the most specific match
- Review velocity matters more than lifetime totals
- Post weekly to signal activity to Google
- Upload 2-3 new photos every week
- Respond to every review within 24-48 hours
- Keep NAP consistent across all online directories

## Compatibility

Tested with: All AI assistants

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_name}}` | `Sunrise Coffee & Bakery` | Business name |
| `{{business_type}}` | `coffee shop and artisan bakery` | What the business does |
| `{{location}}` | `123 Main Street, Austin, TX` | Business location |
| `{{current_status}}` | `profile exists but not updated` | Current GBP status |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
