---
name: marketing-hook-writer
version: 1.0.0
---

# Initialization

Transform generic service descriptions into compelling, achievement-focused marketing hooks that convert prospects into clients. This skill helps service providers, coaches, consultants, SaaS founders, and freelancers communicate their value proposition in one powerful sentence.

## Structure

- `SKILL.md` - Main skill prompt with hook formulas, workflows, and best practices

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r marketing-hook-writer/ ~/.claude/skills/marketing-hook-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_audience_segment}}` | `entrepreneurs` | Specific customer type (e.g., "first-time SaaS founders") |
| `{{primary_outcome}}` | `gain more clients` | The quantifiable result clients achieve |
| `{{timeframe_days}}` | `30` | Days to achieve results (7-365) |
| `{{audience_blocker_objection}}` | `without spending money` | Unspoken concern to address in hook |
| `{{emotional_transformation}}` | `confidence` | Psychological shift (freedom, credibility, peace of mind) |
| `{{proof_element}}` | `case study` | Type of credibility backing |

## Quick Start

After installation, try:

```
I sell executive coaching for leaders. Can you rewrite this as a specific hook that communicates actual value?
```

Expected output: Multiple hook variants like:
- "I help mid-market CTOs resolve team dysfunction and ship products 3x faster in 60 days"
- "I transform reactive leaders into strategic executives who attract A-player talent"
- "From firefighting to freedom—leadership coaching that gives you your weekends back"

## Key Features

1. **8 Hook Formulas**: Desire Fulfillment, Benefit Spotlight, Transformation Promise, Specific Number, Objection Killer, Value + Emotion, Proclamation Lead, Promise Lead

2. **5 Workflow Types**: Generic-to-Specific, Multi-Variant A/B Testing, Pain Point Mapping, Service Audit, Emotional Integration

3. **Platform Optimization**: LinkedIn headlines, email subjects, sales page headlines, Twitter bios, cold email openers

4. **Quality Checklist**: Specificity, clarity, believability, and differentiation tests

5. **Troubleshooting Guide**: Solutions for generic hooks, believability issues, emotional resonance, audience targeting

---
Downloaded from [Find Skill.ai](https://findskill.ai)
