---
name: niche-down-generator
version: 1.0.0
---

# Niche Down Generator - Initialization

Transform vague professional positioning into specific, high-value market niches. Get AI-powered market analysis, competitive positioning, and premium pricing strategies for freelancers, consultants, and solopreneurs.

## What This Skill Does

The Niche Down Generator helps professionals escape the commodity trap of generalist positioning by:

- Converting broad professional identity into layered niche positioning
- Analyzing market viability (TAM, growth rate, competition)
- Generating ideal client profiles with precision targeting
- Creating positioning statements and go-to-market messaging
- Developing pricing strategies justified by niche expertise
- Mapping competitive gaps and differentiation opportunities

## Package Contents

```
niche-down-generator/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
├── INIT.md       # This file - setup instructions
└── index.md      # Website metadata (not needed for usage)
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r niche-down-generator/ ~/.claude/skills/niche-down-generator/
```

Then reference in conversations:
```
Use skill niche-down-generator to help me find my niche
```

### ChatGPT / Claude.ai / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as your first message
4. The AI will adopt the positioning strategist role

### Custom GPT / Claude Project

1. Create new Custom GPT or Claude Project
2. Paste `SKILL.md` content into the system instructions
3. Save and use the assistant for niche discovery sessions

## Quick Start

After loading the skill, try these prompts:

**Freelancer Niche Discovery:**
```
I'm a graphic designer with 8 years of experience. I've done logo design,
branding, web design, and pitch decks. My clients are mostly startups.
I charge $80/hour but feel like I'm competing on price. Help me specialize.
```

**Career Transition:**
```
I'm transitioning from corporate accounting to freelance bookkeeping.
I have 12 years experience in healthcare and manufacturing. Help me
find a niche where my corporate background is an advantage.
```

**Pricing Strategy:**
```
I'm a copywriter charging $50/hour. I want to specialize in e-commerce
and command premium rates. What niches could 3x my pricing?
```

**Competitive Analysis:**
```
I'm a UX designer in a crowded market. Help me find underserved
segments where I can differentiate and charge more.
```

## Variables

Customize the skill by providing these values in your prompts:

| Variable | Default | Description |
|----------|---------|-------------|
| `current_role` | graphic designer | Your current professional title |
| `industry_focus` | multiple | Industries you currently serve |
| `skill_depth` | intermediate | Your expertise level |
| `niche_depth_level` | 2 | How specialized (1=industry, 2=problem, 3=client-stage) |
| `pricing_current` | $75/hour | Your current rates |
| `target_annual_revenue` | $150000 | Your income goal |

## Expected Outputs

The skill generates:

1. **Niche Recommendations** (2-3 options with analysis)
   - Market size and growth rate
   - Pricing potential
   - Competition level
   - Your competitive advantage

2. **Positioning Package**
   - One-sentence positioning statement
   - Ideal client profile
   - LinkedIn/website copy
   - Elevator pitch

3. **Implementation Roadmap**
   - Portfolio pivot recommendations
   - Credibility-building actions
   - First client acquisition tactics
   - Timeline for transition

## Workflows Included

| Workflow | Best For |
|----------|----------|
| Freelancer Niche Discovery | Finding your first profitable niche |
| Career Transition Positioning | Leveraging existing experience in new field |
| Premium Pricing Justification | Understanding pricing leverage |
| Competitive Niche Mapping | Finding underserved market gaps |
| SaaS Vertical Selection | Product teams choosing industry focus |

## Tips for Best Results

1. **Be specific about past work**: Share details about your best clients and projects
2. **Include pricing context**: Current rates and where you feel price pressure
3. **Mention energy levels**: What work energizes vs. drains you
4. **State your goals**: Income targets, lifestyle preferences, growth ambitions
5. **Ask follow-up questions**: Request deeper analysis on promising niches

## Troubleshooting

**"I don't have enough experience to specialize"**
- The skill will identify adjacent niches where your current experience provides credibility

**"I want to serve everyone"**
- The skill explains economics of specialization and proposes low-risk experiments

**"My niche seems too small"**
- The skill validates market size and suggests adjacent expansions if needed

---
Downloaded from [Find Skill.ai](https://findskill.ai)
