---
name: partnership-opportunity-evaluator
version: 1.0.0
---

# Partnership Opportunity Evaluator - Initialization

A comprehensive framework for systematically evaluating business partnership opportunities using weighted scoring methodologies, risk assessment matrices, and evidence-based decision frameworks.

## What This Skill Does

This skill transforms your AI assistant into a strategic partnership evaluation expert that helps you:

- Conduct pre-partnership due diligence across strategic, financial, operational, and cultural dimensions
- Score potential partners using quantitative weighted methodologies
- Identify and prioritize risks with mitigation strategies
- Compare multiple partnership candidates objectively
- Generate go/no-go recommendations with supporting analysis
- Establish KPIs for ongoing partnership monitoring

## Package Structure

```
partnership-opportunity-evaluator/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This initialization guide
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation Instructions

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r partnership-opportunity-evaluator/ ~/.claude/skills/partnership-opportunity-evaluator/
```

Then invoke with:
```
use skill partnership-opportunity-evaluator
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the `---` frontmatter block
3. Paste into a new ChatGPT conversation as the first message
4. Or save as a Custom GPT with this as the system instructions

### Claude.ai (Web)

1. Open `SKILL.md` in a text editor
2. Copy all content after the `---` frontmatter block
3. Start a new conversation with Claude
4. Paste the skill prompt as your first message
5. Then provide your partnership evaluation request

### Gemini

1. Open `SKILL.md` in a text editor
2. Copy all content after the `---` frontmatter block
3. Paste into Gemini as system context or first message
4. Follow with your partnership evaluation request

### GitHub Copilot

1. Add `SKILL.md` to your project's `.github/copilot-instructions.md`
2. Or paste into Copilot Chat with your query

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{evaluation_focus_areas}}` | `["strategic", "financial", "operational", "cultural"]` | Dimensions to evaluate; customize for partnership type |
| `{{scoring_methodology}}` | `weighted_composite` | Scoring method: weighted_composite, multiplicative, threshold_based |
| `{{risk_threshold_percentage}}` | `25` | Maximum acceptable risk score (0-100) |
| `{{required_roe_minimum}}` | `20` | Minimum ROE percentage for financial viability |
| `{{partnership_tier_weights}}` | `{"strategic": 0.30, "financial": 0.25, "operational": 0.20, "cultural": 0.15, "risk": 0.10}` | Dimension weights for composite scoring |
| `{{due_diligence_depth_level}}` | `comprehensive` | Assessment depth: screening, standard, comprehensive, enhanced |

## Quick Start Examples

### Example 1: Evaluate a Strategic Partner

```
I'm evaluating a potential partnership with TechFlow Solutions, a SaaS provider offering integration capabilities for our platform. They have $50M annual revenue with 30% YoY growth, strong engineering team, but limited sales infrastructure. Our priorities are market expansion and revenue growth. Please run a comprehensive partnership evaluation.
```

### Example 2: Compare Multiple Candidates

```
We're selecting a logistics partner from three candidates:
- SupplyChain Corp: $500M revenue, established, proven track record, higher costs
- LogiStart: Emerging company, lower costs, less experience
- GlobalMove: Mid-market, balanced profile

Create a comparison framework across strategic fit, financial health, operational capabilities, and risks. Recommend the best partner.
```

### Example 3: Risk Assessment Focus

```
We're considering a joint venture with EuroTech GmbH for European market expansion. The partnership looks financially strong, but I'm concerned about regulatory compliance, IP protection, and cultural differences. Focus on identifying and assessing risks with mitigation strategies.
```

## Key Evaluation Dimensions

### Strategic Alignment (30% weight)
- Vision & mission alignment
- Market positioning complementarity
- Growth strategy compatibility
- Resource complementarity

### Financial Viability (25% weight)
- Liquidity ratios (Current, Quick)
- Profitability metrics (Margins, ROE)
- Leverage indicators (D/E, Interest Coverage)
- Partnership economics (ROI, payback period)

### Operational Capability (20% weight)
- Technical expertise depth
- Execution capacity and track record
- Infrastructure readiness
- Talent and leadership strength

### Cultural Compatibility (15% weight)
- Values alignment
- Decision-making processes
- Communication styles
- Work culture fit

### Risk Assessment (10% weight, inverse scoring)
- Legal & regulatory risks
- Operational risks
- Financial risks
- Reputational risks
- Strategic risks

## Decision Framework

| Score | Recommendation | Action |
|-------|----------------|--------|
| 4.5-5.0 | Strong Proceed | Negotiate terms |
| 4.0-4.4 | Proceed with Conditions | Address gaps |
| 3.5-3.9 | Conditional Proceed | Pilot recommended |
| 3.0-3.4 | Reconsider | Seek alternatives |
| 2.5-2.9 | Do Not Proceed | Too risky |
| < 2.5 | Reject | Unsuitable |

## Outputs You'll Receive

1. **Executive Summary** - Go/No-Go recommendation with key scores and top strengths/risks
2. **Detailed Assessment Report** - Full scoring with evidence and rationale
3. **Risk Register** - Prioritized risks with mitigation strategies
4. **Recommended Next Steps** - Actions, negotiation priorities, pilot recommendations
5. **Monitoring Dashboard Template** - KPIs for ongoing partnership tracking

## Customization Tips

### For Technology Partnerships
- Increase operational weight to 30%
- Add technology compatibility deep-dive
- Focus on IP and security risks

### For Distribution Partnerships
- Emphasize market access analysis
- Assess channel conflict risks
- Evaluate geographic coverage

### For Joint Ventures
- Increase financial weight to 35%
- Focus on governance structure
- Clarify IP ownership upfront

## Best Practices

1. **Always define objectives first** - Partnership success metrics should drive evaluation criteria
2. **Don't skip cultural assessment** - Partnerships fail more often from culture clash than financial issues
3. **Use pilot projects** - For scores 3.5-3.9, start with limited scope before full commitment
4. **Document everything** - Keep evaluation records for post-mortem learning
5. **Review regularly** - Partnerships drift; schedule quarterly strategic alignment reviews

## Related Skills

- Due Diligence Checklist Generator
- Vendor Risk Assessment
- Competitive Analysis
- Financial Projections
- Negotiation Stance Builder
- Exit Strategy Planner
- Contract Analyzer

---
Downloaded from [Find Skill.ai](https://findskill.ai)
