---
name: product-hunt-launch-checklist
version: 1.0.0
---

# Initialization

Product Hunt Launch Checklist - Master Product Hunt launches with data-driven strategies from 18 #1 launches. Provides complete 4-week prep timeline, launch day execution playbook, supporter activation workflows, and post-launch growth tactics.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive launch guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r product-hunt-launch-checklist/ ~/.claude/skills/product-hunt-launch-checklist/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_name}}` | `Your Product` | The name of your product being launched |
| `{{product_category}}` | `SaaS` | Product type (SaaS, mobile app, developer tool, etc.) |
| `{{launch_date}}` | `4 weeks from now` | Target Product Hunt launch date |
| `{{email_list_size}}` | `500` | Current email subscriber count |
| `{{prep_timeline_weeks}}` | `4` | Weeks allocated for pre-launch preparation |
| `{{supporter_team_size}}` | `50` | Number of activated supporters to coordinate |

## Key Features

- **Pre-Launch Strategy**: Complete 4-week preparation roadmap with week-by-week tasks
- **Launch Day Execution**: Hour-by-hour timeline from 12 AM to midnight PST
- **First Comment Template**: Proven format based on analysis of 18 #1 launches
- **Email Templates**: Pre-dawn, main blast, and supporter coordination emails
- **Supporter Activation**: 2-week workflow for building and activating your network
- **Common Mistakes**: What to avoid and why, with corrective actions
- **Success Benchmarks**: Metrics for prep, launch day, and post-launch phases
- **Troubleshooting**: Solutions for low traction, negative feedback, and flagged accounts

## Example Usage

```
I'm launching a productivity SaaS called 'TaskFlow' on Product Hunt in 4 weeks.
I have 200 Twitter followers and an email list of 300 people. Walk me through
my exact pre-launch checklist: what should I do each week for the next 4 weeks
to maximize launch success?
```

## Quick Reference

### Critical Success Factors
1. Account must be 30+ days old (365-day streak = 10x algorithm advantage)
2. First 4 hours determine visibility for the remaining 20 hours
3. Respond to EVERY comment within 24 hours (ideally within 1 hour)
4. Never directly ask for upvotes - use "support" or "check it out"
5. Only ~10% of launches get featured (2024 data)

### Launch Day Timing (PST)
- 12:10 AM: Launch product (after checking competition)
- 12:15 AM: Email inner circle supporters
- 10-11 AM: Main email blast to full list
- Throughout: Respond to all comments immediately

### Benchmarks for Success
| Phase | Minimum | Good | Excellent |
|-------|---------|------|-----------|
| Email list | 200 | 500 | 2,000+ |
| Notify signups | 50 | 200 | 500+ |
| Day 1 upvotes | 100 | 300 | 500+ |
| Comments | 30 | 75 | 150+ |

---

Downloaded from [Find Skill.ai](https://findskill.ai)
