---
name: saas-free-trial-optimizer
version: 1.0.0
---

# SaaS Free Trial Optimizer - Initialization

Design high-converting free trial mechanics that maximize user activation, create urgency, and convert prospects to paying customers with data-driven optimization strategies.

## What This Skill Does

This skill transforms you into a SaaS growth strategist specializing in:
- Trial length optimization (7, 14, or 30-day decisions)
- Credit card vs. no-credit-card trial strategies
- Onboarding flow design for rapid activation
- Email nurture sequences (proven 31% conversion template)
- Paywall design and post-trial handling
- Activation metric definition
- Common conversion mistake diagnosis

## Structure

```
saas-free-trial-optimizer/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
└── INIT.md       # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### For Claude Code / Claude Projects

```bash
# Copy to Claude Code skills directory
cp -r saas-free-trial-optimizer/ ~/.claude/skills/saas-free-trial-optimizer/
```

Or add to Claude Project knowledge by uploading `SKILL.md`.

### For ChatGPT

1. Open ChatGPT
2. Start a new conversation or use a Custom GPT
3. Copy the content from `SKILL.md` (everything after the `---` frontmatter)
4. Paste as your system prompt or initial context

### For Other AI Assistants (Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy all content after the frontmatter section
3. Paste into your AI assistant as initial context
4. Begin with your trial design question

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `product_type` | B2B SaaS | Type of SaaS product being optimized |
| `trial_duration_days` | 14 | Base trial length to consider |
| `require_credit_card` | false | Default credit card requirement |
| `target_audience` | SMB decision-makers | Primary buyer persona |
| `time_to_value_hours` | 24 | Target time for users to reach aha moment |
| `feature_access_level` | full | Trial feature access (full, premium_limited, core_only) |

## Example Usage

After loading the skill, try prompts like:

**Basic trial design:**
```
I'm building a CRM for real estate agents. We charge $49/month per user.
How should I structure my free trial?
```

**Conversion optimization:**
```
Our current 30-day trial has 18% conversion. Users who create their
first deal have 45% conversion. How do we improve?
```

**Email sequence:**
```
Design a 7-email trial nurture sequence for my project management
SaaS targeting marketing agencies.
```

**Enterprise trial:**
```
We sell $50k/year compliance software to banks. Should we even
offer self-serve trials? If so, how long?
```

## Key Frameworks Included

1. **Trial Length Decision Matrix** - 7 vs 14 vs 30 day guidance
2. **Credit Card vs No-Card Trade-offs** - Volume vs quality analysis
3. **5 Trial Design Frameworks** - Feature-complete, credit-required, freemium-hybrid, personalized, gamified
4. **7-Email Sequence Template** - Proven 31% conversion structure
5. **Activation Metric Framework** - Define aha moment and key actions
6. **Paywall Design Elements** - Post-trial conversion optimization
7. **7 Common Mistakes Diagnostic** - Identify and fix conversion blockers

## Research Foundation

Based on field experiments with 680,588+ users and analysis from:
- Large-scale randomized trials on trial duration
- Academic research on SaaS conversion optimization
- Best practices from 50+ SaaS companies
- Real-world email sequences with documented results

---
Downloaded from [Find Skill.ai](https://findskill.ai)
