---
name: sales-email-sequence-generator
version: 1.0.0
---

# Sales Email Sequence Generator - Initialization

Create persona-based multi-touch email sequences with timing optimization, objection handling, and proven conversion frameworks for cold outbound, welcome, nurture, and upsell campaigns.

## Package Structure

```
sales-email-sequence-generator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md contains the complete email sequence generation system.

## Quick Start

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r sales-email-sequence-generator/ ~/.claude/skills/sales-email-sequence-generator/
```

Then reference in conversations:
```
@sales-email-sequence-generator Generate a 7-email cold outbound sequence for VP Sales at SaaS companies
```

### For ChatGPT / Other AI Assistants

1. Open `SKILL.md`
2. Copy everything after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of your conversation
4. Start with a request like: "Generate a welcome sequence for new trial users"

## Variables Reference

| Variable | Default | Options | Description |
|----------|---------|---------|-------------|
| `sequence_type` | `cold_outbound` | cold_outbound, welcome, lead_nurture, post_purchase, upsell, re_engagement | Type of email campaign |
| `buyer_persona` | `decision_maker` | executive_cfo, vp_sales, it_director, end_user, marketing_leader, procurement | Target role |
| `sequence_length` | `7` | 3-12 | Number of emails in sequence |
| `email_spacing_pattern` | `exponential` | aggressive, standard, exponential, nurture | Follow-up timing |
| `industry_vertical` | `saas` | saas, healthcare, finance, manufacturing, retail, b2b_services | Industry context |
| `call_to_action_goal` | `book_meeting` | book_meeting, schedule_demo, free_trial_signup, whitepaper_download | Primary conversion goal |

## Example Prompts

### Cold Outbound to CFO
```
Generate a 7-email cold outbound sequence targeting CFOs at mid-market
manufacturing companies. Focus on cash flow optimization. Use exponential
spacing. Include LinkedIn touch on Day 4.
```

### Welcome Sequence for SaaS
```
Create an 8-email welcome sequence for new free trial signups at our
e-commerce platform. Target small business owners. Include urgency
offer in Email 7.
```

### Multi-Persona Lead Nurture
```
Generate 3 separate 6-email nurture sequences for:
1. VP of Sales (quota/productivity focus)
2. IT Director (security/integration focus)
3. End-users (ease of use focus)
All for a sales enablement platform targeting enterprise customers.
```

## What You'll Get

Each generated sequence includes:

- **Complete email templates** with subject lines and body copy
- **Persona-optimized messaging** tailored to buyer role
- **Day-by-day timing schedule** with optimal intervals
- **Objection handling emails** at strategic positions
- **LinkedIn touchpoints** for multi-channel coordination
- **Performance benchmarks** (open rate, reply rate, conversion)
- **A/B test variations** for subject lines and CTAs

## Sequence Types Overview

| Type | Emails | Duration | Purpose |
|------|--------|----------|---------|
| Cold Outbound | 7 | 23-29 days | Convert cold prospects to meetings |
| Welcome | 8 | 15 days | Activate new signups |
| Lead Nurture | 6 | 6 weeks | Warm prospects over time |
| Post-Purchase | 7 | 60 days | Maximize customer lifetime value |
| Upsell | 5 | 30 days | Drive upgrades and expansions |
| Re-engagement | 4 | 14 days | Win back inactive contacts |

## Timing Patterns

| Pattern | Example | Best For |
|---------|---------|----------|
| Aggressive | Day 1, 2, 4, 6, 8 | Hot leads, time-sensitive |
| Standard | Day 1, 3, 5, 8, 14 | Most cold outbound |
| Exponential | Day 1, 2, 5, 10, 17, 24 | Balanced persistence |
| Nurture | Day 1, 7, 14, 21, 28, 35 | Long sales cycles |

## Integration with Tools

This skill works best when combined with:

- **Email sequencing platforms**: Apollo, HubSpot, Outreach, Mixmax
- **CRM systems**: Salesforce, HubSpot, Pipedrive
- **Email validation**: ZeroBounce, NeverBounce
- **LinkedIn outreach**: LinkedIn Sales Navigator

## Tips for Best Results

1. **Always specify persona** - CFO needs different messaging than end-user
2. **Include industry context** - Terminology and pain points vary by vertical
3. **Start with exponential timing** - Best balance of persistence vs. annoyance
4. **Request objection handling** - Ask for Email 5 to address specific concerns
5. **Add LinkedIn touches** - 20%+ higher meeting rates with multi-channel
6. **Keep cold emails short** - Under 100 words for executive personas

---

Downloaded from [Find Skill.ai](https://findskill.ai)
