---
name: scope-creep-blocker
version: 1.0.0
---

# Scope Creep Blocker - Initialization

Protect your profitability and sanity with professional scripts, frameworks, and processes for preventing, managing, and recovering from scope creep on client projects.

## What This Skill Does

The Scope Creep Blocker provides:
- Ready-to-use communication scripts for handling out-of-scope requests
- Formal change control processes adapted to your situation
- Impact analysis frameworks to quantify what additions really cost
- Trade-off conversations that make clients choose priorities
- Prevention strategies for future projects
- Recovery plans when scope creep has already damaged a project

## Structure

```
scope-creep-blocker/
├── SKILL.md    # Main skill prompt (use this)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill - all functionality is contained in SKILL.md.

## Post-Init Steps

### For Claude Code Users

Copy the skill to your Claude Code skills directory:

```bash
cp -r scope-creep-blocker/ ~/.claude/skills/scope-creep-blocker/
```

Then reference it in your conversations:
```
Use the scope-creep-blocker skill to help me respond to this client request...
```

### For ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of your conversation
4. Describe your scope creep situation and get scripts/strategies

### Quick Start

After setup, try this prompt:

```
My client just asked me to add a feature that wasn't in our original scope.
We agreed on $8,000 for a dashboard with viewing and filtering. Now they
want CSV/PDF export functionality and said "it shouldn't take too long."
How do I respond professionally without absorbing extra work for free?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `project_type` | `fixed-price` | Your pricing model (fixed-price, hourly, retainer) |
| `client_relationship` | `new client` | History with this client (new, repeat, long-term) |
| `scope_situation` | `mid-project request` | When the issue occurred (pre-project, mid-project, chronic, crisis) |
| `impact_threshold` | `$5000 or 1 week` | Threshold for formal approval process |
| `communication_style` | `professional-firm` | Your preferred tone (professional-firm, collaborative-soft, direct-assertive) |

## Use Cases

1. **Mid-Project Scope Request** - Client asks for something not in the original agreement
2. **Pre-Project Prevention** - Setting up scope documents and change control processes
3. **Chronic Scope Creep Recovery** - Multiple additions have accumulated and project is at risk
4. **Change Request Documentation** - Creating formal CR forms and approval workflows
5. **Trade-off Conversations** - Making clients choose priorities when they want everything
6. **Client Education** - Explaining why scope management matters to resistant clients

## Key Frameworks Included

- **Triple Constraint (Iron Triangle)** - Time, Cost, Scope trade-offs
- **Phase 2 Deferral Strategy** - Accept ideas, defer implementation
- **Change Request Process** - Formal documentation and approval
- **Priority Forcing Technique** - Make clients explicitly choose trade-offs
- **Scope Baseline Documentation** - What's included vs. excluded

## Communication Templates

The skill includes ready-to-use scripts for:
- First response to scope requests
- Scope additions with cost impact
- Graceful decline of requests
- Educating resistant clients
- Setting up prevention for new projects
- Handling common objections ("It's just a small thing!", "I don't have budget", etc.)

---

Downloaded from [Find Skill.ai](https://findskill.ai)
