---
name: side-hustle-scaling
version: 1.0.0
---

# Side Hustle Scaling System - Initialization

Transform your side hustle from hobby income to a scalable, profitable business with strategic roadmaps for systemization, delegation, productization, and full-time transition.

## What This Skill Does

This skill turns your AI assistant into a Side Hustle Scaling Strategist that helps you:

- **Diagnose your growth stage** (validation, traction, scaling, exiting)
- **Identify your primary bottleneck** (time, leads, cash, fulfillment)
- **Create delegation systems** with SOPs and hiring workflows
- **Productize services** into scalable offerings
- **Plan financial transitions** from day job to full-time founder
- **Avoid common pitfalls** like dumb scaling and premature quitting

## Structure

```
side-hustle-scaling/
├── SKILL.md      # Main skill prompt (copy this to your AI assistant)
└── INIT.md       # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code (Recommended)

```bash
# Copy the skill to your Claude Code skills directory
cp -r side-hustle-scaling/ ~/.claude/skills/side-hustle-scaling/
```

Then reference with: `Read ~/.claude/skills/side-hustle-scaling/SKILL.md`

### ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter (`---`)
3. Paste into a new conversation as your first message
4. Begin describing your side hustle situation

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content into the system instructions
3. Add a name like "Side Hustle Scaling Coach"
4. Optionally add the variables as configurable fields

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_model}}` | `service-based` | Type of hustle: service-based, e-commerce, SaaS, creator |
| `{{current_stage}}` | `traction` | Maturity: validation, traction, scaling, exiting |
| `{{monthly_revenue}}` | `2000` | Current monthly revenue in USD |
| `{{weekly_hours}}` | `15` | Hours available per week |
| `{{primary_bottleneck}}` | `time` | Main constraint: time, leads, cash, fulfillment |
| `{{risk_tolerance}}` | `moderate` | Quit-job willingness: low, moderate, high |

## Example Usage

**Service Business Scaling:**
```
I run a freelance copywriting hustle making $3,000/month working 20 hours/week.
I'm maxed out on capacity. My primary_bottleneck is time and risk_tolerance is
moderate. Create a scaling roadmap to reach $10k/month within 12 months.
```

**E-commerce Growth:**
```
My Etsy candle shop is in the traction stage ($800/mo). I want to scale to
$5k/mo but fear shipping overwhelm. Create a roadmap for automating fulfillment
and moving to Shopify.
```

**Full-Time Transition:**
```
I'm a SaaS dev with a $4k/mo side project. My risk_tolerance is low. Outline a
12-month financial plan to transition from my job to full-time founder safely.
```

## Core Frameworks Included

1. **Validation-to-Traction Loop** - Prove the idea makes money
2. **Delegation Pipeline** - Free up founder time with SOPs and VAs
3. **Service-to-Product Transition** - Create scalable offerings
4. **Financial Transition Plan** - The 75/6 Rule for quitting safely

## Key Metrics to Track

- Monthly revenue and growth rate
- Revenue per hour worked
- Customer acquisition cost (CAC)
- Lifetime value (LTV)
- Hours worked per week
- Pipeline visibility (months ahead)

## Related Skills

- [Side Hustle Ideas Generator](/skills/productivity/side-hustle-ideas/) - Find opportunities
- [Side Hustle Viability Scorer](/skills/productivity/side-hustle-viability-scorer/) - Evaluate viability
- [Virtual Assistant Delegator](/skills/solopreneur/virtual-assistant-delegator/) - Hire VAs
- [Pricing Confidence Booster](/skills/solopreneur/pricing-confidence-booster/) - Raise rates
- [Scope Creep Blocker](/skills/solopreneur/scope-creep-blocker/) - Protect margins

---
Downloaded from [Find Skill.ai](https://findskill.ai)
