---
name: testimonial-extractor
version: 1.0.0
---

# Testimonial Extractor - Initialization

AI-powered interview framework that extracts compelling testimonials and case study material from client conversations using strategic questions, STAR methodology, and emotional arc mapping.

## What This Skill Does

Transform generic testimonial requests into strategic conversations that yield authentic, conversion-driving case studies and testimonials. This skill helps:

- Generate strategic interview questions in optimal sequence
- Extract emotional journeys alongside hard metrics
- Structure responses using STAR method (Situation-Task-Action-Result)
- Identify quantifiable results that prove value
- Create multi-format outputs from single interviews
- Handle consent and permission workflows

## Package Structure

```
testimonial-extractor/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r testimonial-extractor/ ~/.claude/skills/testimonial-extractor/
```

Then reference in your `.claude/settings.json` or use directly in conversations.

### For ChatGPT / Custom GPT Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your Custom GPT instructions or conversation

### For Other AI Assistants (Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy the main content (everything after the YAML frontmatter)
3. Paste at the start of your conversation
4. The AI will adopt the Testimonial Extractor persona

## Quick Start Usage

After installation, try these prompts:

**Prepare for an interview:**
```
I have a client call tomorrow with a SaaS company we helped increase
their conversion rate by 35%. Help me prepare interview questions
for a case study.
```

**Process raw interview notes:**
```
Here are my notes from a client interview. Help me extract a
150-word website testimonial and identify 3-5 key metrics.

[paste your notes]
```

**Create permission request:**
```
Generate an email asking my client [Company Name] for permission
to use their success story as a case study.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{interview_duration_minutes}}` | `60` | Interview length (30 = brief, 90 = comprehensive) |
| `{{emotion_focus_level}}` | `7` | Emotion vs. data balance (1-10 scale) |
| `{{quantification_threshold}}` | `3-5` | Minimum metrics to capture |
| `{{testimonial_length_target}}` | `150-200` | Target word count |
| `{{consent_format}}` | `email_approval` | Permission method |
| `{{output_format}}` | `written` | Primary output type |

## Included Workflows

1. **Quick Testimonial Extraction** (30 min) - Post-project quick wins
2. **Deep-Dive Case Study Interview** (60-90 min) - Comprehensive coverage
3. **Email + Follow-up Testimonial** - When interviews aren't feasible
4. **Video Testimonial Session** (45 min) - On-camera testimonials
5. **Case Study Review & Approval Cycle** - Client approval workflow

## Best For

- B2B/SaaS marketing teams building case studies
- Agencies collecting client success stories
- Freelancers and consultants gathering social proof
- Customer success teams documenting wins
- Content marketers responsible for social proof

## Example Outputs

**Website Testimonial:**
```
"Before working with [Provider], we were spending 4 hours on every
email campaign—it was crushing our ability to respond to market
changes.

Since implementing their solution, we've cut that to 15 minutes.
We've launched 3x more campaigns and our conversion rate is up 45%.

If you're drowning in manual marketing work, I'd highly recommend
[Provider]. They've been a game-changer for our team."

— Sarah Chen, Marketing Director at TechStartup Inc
```

**LinkedIn Quote:**
```
"45% increase in conversion rate. Working with [Provider]
transformed how we approach email marketing. If you're a
SaaS company struggling with campaign velocity, talk to them."

— Sarah Chen, Marketing Director
```

---

Downloaded from [Find Skill.ai](https://findskill.ai)
