---
name: value-based-proposal-architect
version: 1.0.0
---

# Initialization

Value-Based Proposal Architect helps freelancers and consultants create outcome-focused proposals that win engagements by selling business value rather than billable hours.

## Structure

- `SKILL.md` - Main skill prompt with 11-section proposal framework, pricing models, and success factors

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r value-based-proposal-architect/ ~/.claude/skills/value-based-proposal-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant (Claude, ChatGPT, Gemini, Copilot)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{client_name}}` | `[Client Company]` | Name of the prospective client |
| `{{project_type}}` | `strategy consulting` | Type of consulting engagement |
| `{{pricing_model}}` | `tiered` | Pricing approach (tiered, fixed, value-based, retainer) |
| `{{engagement_duration}}` | `12 weeks` | Expected project timeline |
| `{{target_roi}}` | `10:1` | Expected ROI multiple for client |

## Key Features

### 11-Section Proposal Framework
1. Executive Summary
2. Background & Current State
3. Business Objectives
4. Proposed Solution & Approach
5. Scope & Deliverables
6. Project Timeline
7. Team & Expertise
8. Investment & Pricing Options
9. Assumptions & Constraints
10. Why Partner With Us
11. Next Steps

### 5 Pricing Models
- Fixed Fee for Defined Outcome
- Tiered/Modular Pricing (Bronze/Silver/Gold)
- Value-Based Pricing (% of value created)
- Monthly Retainer
- Upfront + Milestone

### Critical Success Factors
- Problem-first approach
- Quantify everything
- Multiple price options
- Explicit client responsibilities
- Assumptive language

### Common Mistakes Prevention
- Avoid listing hours
- No single price options
- Always include ROI justification
- Keep under 8 pages

## Usage Example

```
I'm a marketing consultant preparing a proposal for a mid-market SaaS
company ($5M ARR) that wants help reducing customer churn from 28% to
15% (industry benchmark).

My approach: customer success process redesign, automation, team training
Timeline: 12 weeks
My typical rate: $150/hour

Help me create a value-based proposal with:
- Quantified business impact
- 3 pricing tiers
- ROI justification for recommended option
- Clear scope boundaries
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
