---
name: value-proposition-generator
version: 1.0.0
---

# Value Proposition Generator - Initialization

Create segment-specific value propositions that differentiate your offering and resonate with target customers using the Value Proposition Canvas and Jobs-to-Be-Done frameworks.

## Overview

This skill transforms business inputs (product features, customer segments, pain points, competitors) into compelling, differentiated value propositions for each target customer segment. It uses proven strategic marketing frameworks including:

- **Value Proposition Canvas (Strategyzer)**: Two-sided framework mapping customer profile to value map
- **Jobs-to-Be-Done (JTBD)**: Deep customer psychology methodology
- **Competitive Differentiation**: SWOT analysis and positioning strategies

## Structure

```
value-proposition-generator/
├── SKILL.md    # Main skill prompt (comprehensive methodology)
├── INIT.md     # This initialization file
└── .zip        # Downloadable package
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r value-proposition-generator/ ~/.claude/skills/value-proposition-generator/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your preferred AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `target_segment` | Mid-market B2B SaaS buyers | Customer segment with size, industry, role |
| `core_pain_points` | Manual processes, lack of visibility, costly errors | 2-5 customer frustrations |
| `desired_gains` | Efficiency, visibility, risk reduction | 2-5 customer aspirations |
| `unique_strengths` | AI-powered automation, 500+ integrations, 99.9% uptime | 2-4 differentiating capabilities |
| `competitor_names` | Competitor A, Competitor B, Competitor C | 2-5 main competitors |
| `communication_tone` | Persuasive | Formal, conversational, persuasive, casual, informative |
| `industry_context` | SaaS | Industry vertical for sector-specific language |

## Core Capabilities

1. **Segment-Specific Value Proposition Generation** - Create tailored value propositions for 3-5 distinct customer segments with unique messaging for each

2. **Customer Pain & Gain Analysis** - Identify and map customer pains, jobs-to-be-done, and desired gains for each segment

3. **Competitive Differentiation Framework** - Analyze competitor offerings and generate positioning that highlights unique advantages

4. **Value Proposition Canvas Creation** - Generate visual two-sided canvases showing customer profiles matched against value maps

5. **Multi-Tone Message Variations** - Generate value propositions in multiple tones (persuasive, conversational, formal) for different channels

6. **Feature-to-Benefit Translation** - Convert product features into customer-centric benefits that resonate emotionally and functionally

7. **Sales Enablement Assets** - Create one-page positioning sheets, battle cards, and elevator pitches

## Key Workflows

### Workflow 1: Segment Discovery & Mapping
Define segments → Create customer profiles → Map value → Identify gaps → Generate statements

### Workflow 2: Competitive Differentiation
Identify competitors → Feature analysis → SWOT → Differentiation strategy → Positioning statements

### Workflow 3: Multi-Segment Portfolio
Prioritize segments → Create portfolio → Tone variations → Channel-specific messaging

### Workflow 4: Sales Enablement
Map objections → One-page sheets → Elevator pitches → Battle cards

### Workflow 5: Feature Translation
Inventory features → Benefit chains → Before/after scenarios → Segment framing

## Best Practices

**DO:**
- Go narrow before broad (one segment deeply first)
- Lead with outcome, not features
- Validate with actual customers
- Address both buyer AND user needs
- Include emotional AND functional benefits
- Test message resonance iteratively

**DON'T:**
- Assume alignment exists without validation
- Mix buyer priorities with user priorities
- Create generic "for everyone" positioning
- Skip customer research phase
- Communicate features when customers want outcomes
- Stay with weak differentiation

## Example Usage

```
I'm launching a B2B SaaS product that helps marketing teams automate
their social media scheduling. We compete against Buffer, Hootsuite,
and Later. Our key differentiators are AI-powered content suggestions
and built-in analytics. Help me create segment-specific value propositions for:
1. Small business marketing managers (5-20 employees)
2. Agency teams managing multiple clients
3. Enterprise marketing departments
```

## Research Sources

- Value Proposition Canvas (Strategyzer/Service Design Tools)
- Jobs-to-Be-Done Framework (Clayton Christensen)
- Simon-Kucher Differentiation Methodology
- B2B SaaS positioning best practices (NPWS)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
