---
name: vendor-payment-terms-negotiator
version: 1.0.0
---

# Vendor Payment Terms Negotiator - Initialization

Develop and execute effective strategies for negotiating favorable supplier payment terms while maintaining strong vendor relationships and optimizing working capital.

## What This Skill Does

This skill transforms you into an expert procurement strategist who helps businesses:

- **Assess current vendor payment terms** and identify optimization opportunities
- **Develop negotiation strategies** with BATNA analysis and value propositions
- **Design alternative payment structures** (dynamic discounting, milestone payments, consignment)
- **Execute negotiations** with scripts, tactics, and objection handling
- **Calculate working capital impact** of term changes
- **Preserve vendor relationships** while achieving aggressive cash flow goals

## Structure

```
vendor-payment-terms-negotiator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r vendor-payment-terms-negotiator/ ~/.claude/skills/vendor-payment-terms-negotiator/
```

Then reference in your prompts or add to project instructions.

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy the full content after the frontmatter (after the second `---`)
3. Paste into a new conversation or custom instructions
4. Start with a vendor negotiation scenario

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_net_days}}` | `30` | Current payment terms with vendor |
| `{{target_net_days}}` | `45` | Goal payment terms to negotiate |
| `{{annual_spend_usd}}` | `500000` | Annual spending with vendor |
| `{{relationship_age_months}}` | `12` | Duration of vendor relationship |
| `{{vendor_segment_type}}` | `Leverage` | Vendor tier (Strategic/Bottleneck/Leverage/Tactical) |
| `{{payment_reliability_score}}` | `0.95` | Your on-time payment rate (0-1) |
| `{{early_payment_discount_rate}}` | `0.02` | Discount rate for early payment |
| `{{dpo_improvement_percentage}}` | `15` | Target DPO improvement % |

## Example Usage

### Single Vendor Negotiation
```
I spend $2.8 million annually with our primary packaging supplier. We've had
a 3-year relationship with 98% on-time payment compliance. We're currently
on Net 30 terms, but our cash flow would benefit from Net 45. Create a
negotiation strategy that works for both sides.
```

### Alternative Payment Structure
```
We're implementing a $1.5M software development project over 12 months.
The developer wants 30% upfront, 70% on completion. Design a milestone-based
payment schedule that aligns with our customer payment timing (30% kickoff,
40% at 6 months, 30% final delivery).
```

### Dynamic Discounting Proposal
```
We purchase $850K annually in office supplies on Net 30 with no early payment
discount. Our cash forecast shows we could pay some invoices in 15-20 days
if there was a discount incentive. Develop a dynamic discounting proposal
that's compelling for both parties.
```

## Key Capabilities

1. **Vendor Segmentation** - Classify vendors into Strategic/Bottleneck/Leverage/Tactical tiers
2. **BATNA Development** - Build negotiation leverage through alternatives analysis
3. **Working Capital Modeling** - Quantify cash flow impact of term changes
4. **Negotiation Scripts** - Word-for-word opening and objection handling
5. **Alternative Structures** - Dynamic discounting, milestone payments, consignment
6. **Documentation Templates** - Agreement checklists and confirmation formats
7. **Industry Benchmarking** - Standard terms by relationship maturity and volume

## Best For

- Procurement and supply chain professionals
- CFOs and Treasury managers
- Small business owners managing vendor relationships
- Accounts payable managers
- Supply chain finance specialists
- Anyone optimizing working capital through vendor terms

---
Downloaded from [Find Skill.ai](https://findskill.ai)
