---
name: virtual-assistant-delegator
version: 1.0.0
---

# Initialization

The Virtual Assistant Delegator skill helps solopreneurs and small business owners identify which tasks are realistically achievable at $10/hour rates, create SOPs for successful delegation, and implement systems to hire, train, and manage entry-level virtual assistants effectively.

## Structure

- `SKILL.md` - Main skill prompt with complete delegation framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r virtual-assistant-delegator/ ~/.claude/skills/virtual-assistant-delegator/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `target_hourly_rate` | `$10` | Budget per VA hour - affects which tasks are viable and hiring regions |
| `hours_per_week` | `20` | Expected weekly VA hours (15-20 = part-time, 40 = full-time) |
| `training_budget_hours` | `5` | Hours you'll invest training per new task |
| `timezone_overlap_requirement` | `2 hours` | Minimum daily overlap for real-time communication |
| `quality_target_accuracy` | `95%` | Acceptable error rate threshold for task outputs |
| `months_to_roi` | `3` | Target timeline to break even on delegation investment |

## Quick Start

After installing, start a conversation with:

> "I'm a [business type] spending [X] hours/week on admin tasks. My budget is $[X]/hour for a VA. Help me audit my tasks and identify what I can delegate."

## Capabilities

1. **Task Audit**: Score tasks by complexity, calculate delegation ROI
2. **SOP Creation**: Generate step-by-step procedures for any delegable task
3. **Hiring Playbook**: Job postings, screening processes, trial structures
4. **Training Plans**: Week-by-week onboarding with milestones
5. **Performance Systems**: Scorecards, review agendas, scaling frameworks
6. **Budget Analysis**: Full cost calculations and ROI projections

## Best For

- Solopreneurs drowning in admin work
- Consultants and freelancers with repetitive tasks
- E-commerce operators managing customer service
- Content creators handling community and scheduling
- Anyone who values their time above $10/hour

---

Downloaded from [Find Skill.ai](https://findskill.ai)
