---
name: zapier-automation-designer
version: 1.0.0
description: Design Zapier automations — multi-step zaps, filters, paths, AI actions, workflow blueprints for business automation
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides Zapier automation architecture expertise — designing complete Zap workflows with triggers, multi-step actions, filters, paths, AI actions, formatters, delays, and error handling. Includes 5 ready-to-build workflow blueprints.

**Time to initialize**: ~3 minutes

## Directory Structure

```
zapier-automation-designer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with any AI assistant + Zapier account.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Describe the process you want to automate
2. List the apps you currently use
3. Specify your Zapier plan level
4. Get a complete Zap blueprint with field mappings

### Key Principles

- Start with clear trigger → action flow before adding complexity
- Use Filters early to prevent unnecessary task consumption
- Use Paths for conditional branching (up to 10 branches)
- AI by Zapier adds intelligent text processing inside workflows
- Always test each step with real data before turning on
- Name Zaps descriptively and organize in folders

## Compatibility

Tested with: All AI assistants + Zapier (all plans)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{workflow_goal}}` | `Lead capture to CRM + notifications` | What to automate |
| `{{apps_used}}` | `Google Forms, HubSpot, Gmail, Slack` | Apps in use |
| `{{business_context}}` | `small marketing agency` | Business setup |
| `{{zapier_plan}}` | `Professional plan` | Zapier plan level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
