---
name: statistical-test-selector
version: 1.0.0
description: Decision tree tool for choosing the right statistical test with assumption checks, effect sizes, R/Python code, and APA reporting templates
author: FindSkill.ai
license: MIT
---

# Initialization

Prompt-only skill. Copy SKILL.md content into your AI assistant.

## Directory Structure
```
statistical-test-selector/
├── SKILL.md
└── INIT.md
```

## Dependencies
None

## Post-Init Steps

### Claude Code
```bash
cp -r statistical-test-selector/ ~/.claude/skills/statistical-test-selector/
```

### Other AI Assistants
1. Open `SKILL.md`, copy content after frontmatter, paste into your AI assistant

## Compatibility
Tested with: Claude, ChatGPT, Gemini, Copilot, Llama, Mistral

## What This Skill Does

Guides you through a decision tree to select the correct statistical test based on:
- Dependent variable type (continuous, categorical, ordinal, count, time-to-event)
- Independent variable type (categorical groups, continuous predictor)
- Number of groups or conditions (1, 2, 3+)
- Study design (independent, paired, repeated measures, factorial)
- Sample size and distribution assumptions

Covers: t-tests, ANOVA variants, chi-square, correlation, regression (linear, logistic, ordinal, Poisson), non-parametric alternatives (Mann-Whitney, Wilcoxon, Kruskal-Wallis, Friedman), survival analysis, and factor analysis. For each test: assumptions, effect sizes, R/Python/SPSS code, and APA reporting templates.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
