---
name: thank-you-note-writer
version: 1.0.0
description: Write heartfelt thank you notes for any occasion and format
author: FindSkill.ai
license: MIT
---

# Thank You Note Writer — Initialization

## Overview

This is a prompt-only skill that helps you write genuine, personal thank you notes for any occasion. It uses the Emily Post 5-part structure and includes templates for gifts, interviews, weddings, hospitality, sympathy, and more.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill instructions with templates and etiquette guidelines
- `INIT.md` — This initialization guide

## Directory Structure

```
thank-you-note-writer/
├── SKILL.md    # Main skill with 5-part framework and occasion templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Files to Generate

None — copy `SKILL.md` content directly into your AI assistant.

## Quick Start

### Claude / Claude Code

1. Open `SKILL.md`
2. Copy everything after the second `---`
3. Paste into a new Claude conversation
4. Tell Claude who you're thanking and what for

### ChatGPT / Gemini / Copilot

1. Same — paste the skill content
2. Describe the occasion, recipient, and preferred format
3. The AI writes a personalized thank you note

## Core Capabilities

1. **Occasion Detection** — Identifies the right template based on your situation
2. **5-Part Structure** — Greeting, Thank You, Specific Detail, Forward Look, Close
3. **Multi-Format Support** — Handwritten cards, texts, emails, DMs, formal letters
4. **Tone Matching** — Adjusts warmth/formality based on your relationship
5. **Timing Guidance** — Tells you when to send based on etiquette norms
6. **Mistake Prevention** — Warns about common thank you note pitfalls
7. **Personalization** — Uses your specific details for genuine, non-generic notes
8. **Sensitive Occasions** — Handles bereavement and difficult situations with care

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `occasion` | `a gift` | What you're thanking someone for |
| `format` | `handwritten card` | Delivery format (card, text, email, DM, letter) |
| `relationship` | `friend` | Your relationship to the recipient |

## Usage Examples

### Example 1: Wedding Gift

**User:** "We received a KitchenAid mixer from my aunt for our wedding. She's always been like a second mom to me."

**AI Response:** Writes a warm, handwritten-card-format note that names the mixer, references shared memories of baking together, looks forward to using it for family dinners, and signs from both partners. Includes timing tip (send within 3 months).

### Example 2: Job Interview

**User:** "I had a great interview today with the VP of Engineering at a startup. We talked about their new AI product and I'm really excited about the role."

**AI Response:** Writes a professional email within-24-hours format. References the specific AI product discussion, reiterates enthusiasm, and offers to share relevant portfolio work. Includes subject line suggestion.

### Example 3: Sympathy Support

**User:** "My neighbor brought us meals for a week after my dad passed. I want to thank her but I'm not sure what to say."

**AI Response:** Writes a gentle, brief handwritten note that acknowledges the specific kindness (meals), expresses how it helped during a difficult time, and closes with warmth. Acknowledges that brief is perfectly fine and there's no rush.

### Example 4: Teacher Appreciation

**User:** "My son's 3rd grade teacher stayed after school every Tuesday to help him with reading. He went from struggling to loving books."

**AI Response:** Writes an emotional but genuine note from the parent's perspective, naming the specific impact (Tuesday sessions, reading transformation), expressing what it means to the family, and looking forward to the child's continued love of reading.

## Occasions Covered

- Gifts (birthday, holiday, graduation, any occasion)
- Wedding gifts
- Baby shower gifts
- Job interviews
- Hospitality (hosting, dinner parties, weekend stays)
- Favors and help
- Teacher/mentor appreciation
- Sympathy and bereavement support
- Money and gift cards
- Professional referrals and recommendations

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Note feels too generic | Add more specific details about what the person did |
| Not sure what format to use | Default to handwritten card — it's always appropriate |
| Thanking for money feels awkward | Say "generous gift" and mention what you'll use it for |
| Late sending the note | Just send it — a late thank you beats no thank you |
| Multiple people to thank | Ask the AI to batch-write personalized notes |
| Sensitive situation | Tell the AI the context and it will adjust tone |

## Best Practices

1. **Be specific** — Name the gift, the action, the moment that mattered
2. **Be timely** — Sooner is better, but late is better than never
3. **Be yourself** — The note should sound like YOU, not a greeting card
4. **Keep it short** — 3-5 sentences is the sweet spot for most occasions
5. **Handwrite when possible** — It shows extra effort and care
6. **Don't ask for anything** — A thank you note is not the place for requests
7. **Proofread** — Especially for professional and formal notes

## Combining with Other Skills

- **Professional Email Writer** — For business thank you emails
- **Small Talk Starter** — Maintain the connection after thanking someone
- **Cross-Cultural Communicator** — Navigate gratitude norms across cultures

---
Downloaded from [Find Skill.ai](https://findskill.ai)
