---
title: "Thank You Note Writer"
description: "Write heartfelt thank you notes for any occasion and format. Covers gifts, interviews, weddings, hospitality, sympathy, and more — handwritten cards, texts, emails, and formal letters."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "occasion"
    default: "a gift"
    description: "What you're thanking someone for"
  - name: "format"
    default: "handwritten card"
    description: "Delivery format (handwritten card, text, email, social media DM)"
  - name: "relationship"
    default: "friend"
    description: "Your relationship to the recipient"
---

# Thank You Note Writer

A warm, practical skill for writing genuine thank you notes that make recipients feel truly appreciated. Covers every occasion and format with the Emily Post 5-part structure.

## When to Use This Skill

- After receiving a gift (birthday, holiday, wedding, baby shower)
- After a job interview
- After someone hosted you (dinner, weekend stay, holiday)
- After receiving help or a favor
- After a bereavement (thanking those who supported you)
- For teachers, mentors, or coaches who made a difference
- Anytime you want to express genuine gratitude

## Core Framework: 5-Part Structure

Based on Emily Post's etiquette guidelines, every thank you note should include:

### Part 1 — The Greeting
Address the person by name. Match formality to relationship.
- Casual: "Dear Mom," / "Hey Sarah,"
- Professional: "Dear Ms. Johnson,"
- Warm: "Dearest Aunt Linda,"

### Part 2 — The Thank You Statement
Open with a clear, specific thank you. Name exactly what you're grateful for.
- "Thank you so much for the beautiful cashmere scarf."
- "I can't tell you how much I appreciated you hosting us."

### Part 3 — The Specific Detail
Reference something that shows you noticed and valued their effort. This separates great notes from generic ones.
- "The color is exactly what I would have picked — you know me so well."

### Part 4 — The Forward Look
Connect gratitude to the future for warmth and ongoing connection.
- "I can't wait to wear it to the holiday party next month."

### Part 5 — The Warm Close
End with warmth appropriate to the relationship.
- Casual: "Love," / "Thanks again!"
- Professional: "Best regards," / "Sincerely,"

## Occasion-Specific Templates

### Gift Thank You
Name gift → Why you love it → How you'll use it → Warm close

### Hospitality Thank You
Thank for hosting → Specific moment → How it made you feel → Reciprocate

### Job Interview Thank You
Thank for time → Reference discussion → Reiterate interest → Express enthusiasm
- Send within 24 hours
- Personalize for each interviewer

### Wedding Gift Thank You
Thank for specific gift → How you'll use it → Personal touch → Both names sign
- Must be handwritten
- Send within 3 months

### Teacher/Mentor Thank You
Specific impact → What you learned → How it changed you → Gratitude

### Sympathy/Bereavement Thank You
Acknowledge kindness → How it helped → Warm close
- Send within 2-3 weeks (no rush)
- Brief is fine

### Money/Gift Card Thank You
Don't mention exact amount → "Generous gift" → What you'll use it for

## Format-Specific Guidelines

### Handwritten Card
- Blue or black ink, quality stationery
- 3-5 sentences body
- Mail within 1-2 weeks
- Always trumps digital for personal occasions

### Text Message
- Under 3-4 sentences
- Send within 24 hours
- Good for casual favors and small gifts
- Not for weddings, funerals, or professional situations

### Email
- Clear subject line: "Thank you for [specific thing]"
- 4-6 sentences, proofread carefully
- Within 24 hours for interviews

### Formal Letter
- Business letter format with date
- Quality paper
- For corporate, scholarships, formal situations

## Timing Guidelines

| Occasion | Ideal | Acceptable |
|----------|-------|------------|
| Job interview | Within 24 hours | Same/next day |
| Gift | 1-2 weeks | Up to 1 month |
| Wedding gift | 1 month | Up to 3 months |
| Hospitality | 1 week | Up to 2 weeks |
| Sympathy support | 2-3 weeks | Up to 2 months |

## Common Mistakes to Avoid

- Being generic ("thanks for the gift" without naming it)
- Adding a request to a thank you note
- Over-apologizing for lateness
- Making it about yourself instead of the recipient
- Using a template word-for-word
- Skipping the note because you thanked them in person
- Mass-sending the same note to multiple people

---
Downloaded from [Find Skill.ai](https://findskill.ai)
