---
name: business-trip-optimizer
version: 1.0.0
---

# Business Trip Optimizer - Initialization

Maximize meeting productivity, minimize downtime, and streamline expense tracking for business travel with intelligent itinerary optimization, per diem management, client entertainment planning, and a complete pre-trip through post-trip workflow.

## What This Skill Does

- Optimizes meeting schedules by geographic clustering, buffer time management, and time-of-day best practices to minimize transit and maximize face time
- Manages airport efficiency through TSA PreCheck/Global Entry guidance, lounge access strategy, and layover productivity frameworks
- Tracks expenses using a structured category system with same-day logging, receipt management, and compliance-ready documentation
- Calculates GSA per diem rates including M&IE breakdowns, partial day calculations, and per diem vs. actual expense method comparisons
- Plans client entertainment with restaurant selection criteria, cultural considerations, and proper expense documentation
- Selects hotels based on business productivity criteria: proximity to meetings, work amenities, loyalty program optimization
- Recommends ground transportation strategy (rental car vs. rideshare vs. public transit) with city-specific guidance
- Supports remote work during travel with hotel WiFi optimization, mobile office kit recommendations, and coworking alternatives
- Manages time zones with jet lag mitigation strategies, cross-zone scheduling, and overlap hour calculations
- Maximizes travel day productivity on planes, trains, and in airports
- Handles international business travel additions: visa requirements, power/connectivity, currency management, cultural protocols
- Prepares expense reports with categorization best practices and common rejection prevention
- Routes multi-city trips using hub strategy, open-jaw flights, and overnight optimization
- Maintains health and wellness on the road: exercise, nutrition, sleep quality, and stress management
- Ensures travel policy compliance with pre-trip checklist and common policy issues guide
- Generates post-trip follow-up templates: meeting notes, contact management, trip reports, and expense submission

## Package Structure

```
business-trip-optimizer/
├── SKILL.md       # Main skill prompt (copy to AI assistant)
└── INIT.md        # This file - setup instructions
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r business-trip-optimizer/ ~/.claude/skills/business-trip-optimizer/
```

Then reference in your CLAUDE.md or invoke directly.

### ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation with your AI assistant
4. Describe your upcoming business trip

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the content of `SKILL.md` into the system instructions
3. Save and use for all your business travel planning

## Usage Examples

### Full Trip Planning

```
User: I have a 4-day trip to Chicago with 6 client meetings spread across
the Loop and River North. Company follows GSA per diem. Need to plan a
client dinner for 4 people. Flying from Atlanta, departing Monday morning,
returning Thursday evening.

AI: [Maps meeting locations, clusters by neighborhood, builds day-by-day
schedule with buffer times, selects hotel near primary meeting cluster,
calculates per diem for Chicago, recommends restaurants for client dinner,
provides transportation strategy, and generates expense tracking template]
```

### Meeting Schedule Optimization

```
User: I have 8 meetings in San Francisco over 2 days. Here are the
addresses. Help me cluster them and build an optimal schedule.

AI: [Groups meetings by Financial District, SoMa, and Mission clusters,
assigns to AM/PM blocks, calculates transit times between clusters,
adds appropriate buffers, and flags any scheduling conflicts]
```

### Expense Report Preparation

```
User: I just returned from a 5-day trip to New York. I have all my
receipts photographed. Help me organize my expense report. My company
uses GSA per diem for meals.

AI: [Looks up NYC GSA rates, calculates partial day per diem for travel
days, provides categorization for each expense type, flags common
compliance issues, and generates submission-ready summary]
```

### Multi-City Routing

```
User: I need to visit clients in Boston, New York, and Philadelphia
in one trip. Flying from Dallas. How should I route this?

AI: [Proposes north-to-south or south-to-north routing, evaluates
open-jaw vs hub options, recommends train for BOS-NYC-PHL corridor,
calculates total travel time and cost, builds multi-city itinerary
template with overnight optimization]
```

### International Business Travel

```
User: I have meetings in London and then Frankfurt next month. First
time doing business travel in Europe. What do I need to know about
visas, currency, connectivity, and etiquette?

AI: [Covers ESTA/visa waiver, UK plug vs EU plug adapters, GBP and
EUR currency strategy, eSIM recommendations, business dining etiquette
differences, and international per diem rates for both cities]
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{trip_purpose}}` | client meetings and quarterly business review | Primary reason for the trip |
| `{{destination_city}}` | Chicago, IL | City or cities traveling to |
| `{{trip_duration}}` | 4 days / 3 nights | Trip length including travel days |
| `{{meeting_count}}` | 6 meetings across 2 days | Number of scheduled meetings |
| `{{company_policy_notes}}` | Per diem $75/day M&IE, economy flights, hotel cap $200/night | Company travel policy constraints |

## Key Concepts

### Meeting Schedule Optimization

Geographic clustering reduces transit time between meetings:
- Cluster by neighborhood or district
- Assign clusters to half-day blocks
- 15-min buffer (same building), 30-min (same area), 45-60 min (cross-town)
- Mornings for executives, avoid post-lunch for pitches

### Per Diem System

GSA M&IE breakdown for a $79 per diem destination:
- Breakfast: $18
- Lunch: $20
- Dinner: $36
- Incidentals: $5
- Travel days (first/last): 75% of rate

### Expense Categories

Standard corporate categories: Airfare, Lodging, Ground Transportation, M&IE, Client Entertainment, Conference/Registration, Communication, Miscellaneous. Each requires specific documentation.

### Post-Trip Follow-Up Timeline

- 24 hours: Thank-you emails, meeting notes, CRM updates
- 48 hours: Follow-up materials, schedule next meetings
- 1 week: Expense report, trip summary, LinkedIn connections

## Troubleshooting

**"The schedule is too packed"**
- Tell the AI your energy level preferences and maximum meetings per day
- Request larger buffers between meetings

**"I do not know my company's per diem rate"**
- Ask the AI to look up GSA rates for your destination as a baseline
- Check with your company's travel department or expense policy document

**"I have meetings in unfamiliar neighborhoods"**
- Provide addresses and the AI will estimate transit times and suggest clustering
- Ask for city-specific transportation guidance

**"I need to combine personal days with the business trip"**
- Tell the AI which days are personal and which are business
- It will help you separate expenses and check common policy guidelines

**"My expense report keeps getting rejected"**
- Ask the AI to review your expense categories and documentation
- Common fixes: add business purpose, list attendee names, use proper categories

## Related Skills

- [Travel Budget Optimizer](/skills/travel-events/travel-budget-optimizer/) - Optimize overall travel costs and flight strategies
- [Travel Itinerary Planner](/skills/travel-events/travel-itinerary-planner/) - Detailed day-by-day trip planning
- [Cultural Etiquette Briefer](/skills/travel-events/cultural-etiquette-briefer/) - Cross-cultural business interaction prep
- [Conference Talk Proposal Writer](/skills/travel-events/conference-talk-proposal-writer/) - Combine speaking with business travel

---
Downloaded from [Find Skill.ai](https://findskill.ai)
