---
name: conference-talk-proposal-writer
version: 1.0.0
description: Write winning CFP submissions with compelling abstracts, speaker bios, talk outlines, and audience takeaways for any conference type
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for crafting conference talk proposals (CFP submissions) that get accepted. No scripts or additional files are needed. Use SKILL.md directly with any AI assistant.

The skill helps speakers with:
- Writing compelling talk titles using proven formulas
- Crafting abstracts at multiple lengths (200-word and 400-word versions)
- Building timed talk outlines using narrative structures (3-act, demo sandwich, storytelling arc)
- Formulating concrete, actionable audience takeaways
- Writing speaker bios in short, medium, and long formats
- Conference research strategy and submission planning
- First-time speaker guidance and practice schedules
- Avoiding common rejection reasons

## Directory Structure

```
conference-talk-proposal-writer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None. This is a prompt-only skill.

## Files to Generate

None. The skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r conference-talk-proposal-writer/ ~/.claude/skills/conference-talk-proposal-writer/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start crafting your CFP submission

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- Llama (Meta)
- Mistral

## Variables

Customize these for your specific submission:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{talk_topic}}` | (empty) | The subject of your proposed talk |
| `{{conference_type}}` | tech | Type of conference: tech, academic, industry, meetup |
| `{{experience_level}}` | first_time | Your speaking experience: first_time, experienced |
| `{{talk_format}}` | session | Format: keynote, session, lightning, workshop, panel |
| `{{audience_technical_level}}` | intermediate | Audience level: beginner, intermediate, advanced, mixed |

## Example Usage

After loading the skill, try prompts like:

**First-time speaker at a tech conference:**
"I want to submit a talk to PyCon US about using Python dataclasses and Pydantic for building type-safe REST APIs. I've been doing this at my company for 2 years but I've never spoken at a conference before. The session is 30 minutes. Help me write a complete CFP submission."

**Experienced speaker adapting a talk:**
"I gave a talk about observability at KubeCon last year. Now I want to submit a version for a DevOps Days event that's more beginner-friendly and 20 minutes instead of 40. Help me adapt my proposal."

**Workshop proposal:**
"I want to run a 3-hour workshop at JSConf on building accessible React components. I need a complete proposal with a facilitation plan, exercises, and materials list."

**Lightning talk for a meetup:**
"I have 5 minutes at our local Python meetup to talk about a cool trick with Python decorators. Help me write a tight lightning talk proposal."

**Academic conference submission:**
"I need to submit a paper presentation proposal to CHI (ACM Conference on Human Factors in Computing Systems) about my research on AI-assisted code review. The CFP requires a 300-word abstract and a 4-page extended abstract."

## Tips for Best Results

1. **Be specific about your topic**: The more detail you provide about your subject, the better the output
2. **Name the target conference**: Proposals tailored to specific conferences perform better than generic ones
3. **Share your background**: Your experience informs the speaker bio and credibility signals
4. **Mention constraints**: Word limits, required fields, and format requirements help generate submission-ready content
5. **Iterate**: Use the initial output as a starting point, then refine with follow-up prompts
6. **Research first**: Look at past accepted talks from your target conference before generating your proposal

## CFP Submission Checklist

Use this checklist before submitting:

```
[ ] Title is under 80 characters and clearly communicates value
[ ] Abstract matches the required word count
[ ] Detailed description demonstrates subject mastery
[ ] Outline includes timing for each section
[ ] 3-5 concrete, actionable takeaways listed
[ ] Speaker bio tailored to this conference
[ ] Prerequisites clearly stated
[ ] All required CFP fields completed
[ ] Proofread for typos and grammar
[ ] Submitted before the deadline (not on the last day)
```

---
Downloaded from [FindSkill.ai](https://findskill.ai)
