---
name: cultural-etiquette-briefer
version: 1.0.0
description: Country-specific cultural etiquette briefings covering customs, taboos, business protocols, dining etiquette, gift-giving, and social conventions
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for generating comprehensive cultural etiquette briefings tailored to any destination. No scripts or additional files are needed - simply use SKILL.md directly with any AI assistant.

The skill helps travelers and business professionals with:
- Country-specific greetings, customs, and social protocols
- Business meeting etiquette, negotiation styles, and hierarchy navigation
- Dining customs including utensils, toasting, tipping, and dietary laws
- Gift-giving protocols (what to give, what to avoid, presentation)
- Religious site etiquette for mosques, temples, churches, synagogues, and gurdwaras
- Taboo awareness with severity ratings and alternatives
- Emergency cultural recovery when you have accidentally caused offense

## Directory Structure

```
cultural-etiquette-briefer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r cultural-etiquette-briefer/ ~/.claude/skills/cultural-etiquette-briefer/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Tell it where you are going and why!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- LLaMA (Meta)
- Mistral

## Variables

Customize these for your specific trip or interaction:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{destination_country}}` | Japan | The country or region you are visiting |
| `{{visit_purpose}}` | business | Tourism, business, relocation, or study |
| `{{specific_situation}}` | (empty) | A specific scenario like "formal dinner" or "temple visit" |
| `{{cultural_familiarity}}` | none | Your existing knowledge of the destination culture |
| `{{interaction_type}}` | professional meetings | The kind of interaction you will have most frequently |

## Example Usage

After loading the skill, try prompts like:

**Business trip briefing:**
"I'm traveling to Japan next month for business meetings with a manufacturing company in Osaka. I've never been to Japan before. Give me a complete cultural briefing covering business card exchange, meeting etiquette, dining customs, gifts to bring, and common mistakes Americans make."

**Tourist cultural guide:**
"We're visiting Thailand for two weeks. We want to visit temples, eat street food, and explore both Bangkok and the islands. What cultural rules do we need to know? We're from Canada and have never been to Southeast Asia."

**Relocation preparation:**
"I'm relocating to Germany for work. I'll be living in Munich and working at a German company. Help me understand everything from workplace culture and punctuality to social norms, neighbor relations, and recycling rules."

**Specific situation help:**
"I've been invited to a traditional Indian wedding in Rajasthan next month. What should I wear, what gifts should I bring, what are the ceremonies like, and what should I absolutely not do?"

**Religious site visit:**
"I'm visiting Istanbul and want to see the Blue Mosque, Hagia Sophia, and some synagogues in the old quarter. What are the dress codes, behavior rules, and protocols for each?"

## Cultural Frameworks Referenced

This skill draws on established cultural intelligence frameworks:

- **Hofstede's Cultural Dimensions**: Power distance, individualism, uncertainty avoidance, masculinity, long-term orientation, indulgence
- **Erin Meyer's Culture Map**: Communication, evaluation, persuasion, leading, deciding, trusting, disagreeing, scheduling
- **Edward T. Hall**: High-context vs. low-context cultures, monochronic vs. polychronic time
- **GLOBE Study**: Cultural clusters and leadership expectations across societies

## Tips for Best Results

1. **Be specific about your background**: Mention where you are from so the skill can highlight the biggest gaps between your home culture and the destination
2. **Describe specific situations**: "First meeting with a Japanese CEO" gets better results than "going to Japan"
3. **Ask follow-up questions**: If something is unclear, ask for more detail on that specific custom
4. **Request emergency phrases**: Always ask for key apology and politeness phrases in the local language
5. **Check timing**: If traveling during a holiday or religious period (Ramadan, Diwali, Golden Week), mention it for time-sensitive advice
6. **Verify with locals**: Use the briefing as preparation, then confirm details with local colleagues or contacts

---
Downloaded from [FindSkill.ai](https://findskill.ai)
