---
name: event-run-of-show-creator
version: 1.0.0
description: Create minute-by-minute event production schedules with AV cues, staff assignments, speaker transitions, contingency plans, and catering coordination for any event type
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for creating comprehensive run-of-show (ROS) documents for live, virtual, and hybrid events. No scripts or additional files are needed. Use SKILL.md directly with any AI assistant.

The skill helps event producers with:
- Building minute-by-minute production timelines with standardized column format (time, duration, activity, who, where, AV/tech, notes/backup)
- Creating event-specific templates for corporate conferences, product launches, galas/fundraisers, workshops, hybrid events, and virtual events
- Generating technical production cue sheets for lighting, sound, and video operators
- Managing speakers with green room protocols, mic check schedules, and transition choreography
- Assigning staff roles with radio channel assignments and escalation matrices
- Planning contingencies for speaker no-shows, tech failures, weather issues, medical emergencies, and schedule overruns
- Coordinating venue logistics including load-in sequences, room flip times, and load-out plans
- Timing catering service with dietary requirement matrices and alcohol management
- Designing registration and check-in flows with station assignments
- Structuring post-event wrap including teardown timelines, debrief agendas, and thank-you communications
- Establishing communication protocols with emergency contacts and escalation paths

## Directory Structure

```
event-run-of-show-creator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None. This is a prompt-only skill.

## Files to Generate

None. The skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r event-run-of-show-creator/ ~/.claude/skills/event-run-of-show-creator/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start creating your run-of-show document

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- Llama (Meta)
- Mistral

## Variables

Customize these for your specific event:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | corporate conference | Type of event: corporate conference, product launch, gala/fundraiser, workshop/training, hybrid event, virtual event |
| `{{event_duration}}` | 8 hours | Total duration including setup and teardown |
| `{{venue_type}}` | hotel ballroom | Venue type: hotel ballroom, convention center, outdoor, office, virtual platform, hybrid |
| `{{audience_size}}` | 200 | Expected number of attendees |
| `{{production_complexity}}` | moderate | Production level: basic, moderate, high-production |

## Example Usage

After loading the skill, try prompts like:

**Full-day corporate conference:**
"I'm producing a full-day corporate conference for 300 attendees at a convention center. We have 2 keynote speakers, 4 breakout sessions across 3 rooms, a networking lunch, a panel discussion, and a closing reception. Create a complete run-of-show from 7 AM load-in to 8 PM load-out with AV cues, staff assignments, and contingency plans."

**Product launch event:**
"We're launching a new SaaS product for 150 people at a boutique hotel. The event is 4 hours with a CEO presentation, live product demo, customer testimonial, and hands-on demo zone. I need a run-of-show with the reveal moment choreographed precisely and a pre-recorded backup of the demo."

**Charity gala and fundraiser:**
"We're hosting a 500-person gala and fundraiser at a hotel ballroom. It includes cocktail hour, plated dinner, keynote speech, live auction with 10 items, a fund-a-need paddle raise, and a band for dancing. Create the full ROS with catering timing, auction coordination, and entertainment transitions."

**Half-day workshop:**
"I'm running a half-day leadership workshop for 40 managers at our office. Four modules, each with exercises, plus morning coffee and a working lunch. Create a streamlined ROS focused on module timing and facilitator notes."

**Hybrid conference:**
"We're running a hybrid conference with 200 in-person attendees and 500 virtual. Two keynotes, three breakout tracks, and networking. I need the ROS to show parallel in-person and virtual activities, with stream management cues and virtual engagement touchpoints."

**Virtual summit:**
"We have a 4-hour virtual summit on Zoom with 3 speakers, Q&A after each, networking breakout rooms, and a closing panel. Create a ROS with platform management cues, engagement poll timing, and tech producer notes."

## Tips for Best Results

1. **Be specific about your program**: List every session, speaker, meal, and activity — the more detail you provide, the more precise the timeline
2. **Include venue constraints**: Load-in times, noise curfews, room flip limitations, and union labor rules all affect the schedule
3. **Specify your team size**: The number of staff determines how many parallel activities can run simultaneously
4. **Mention your AV setup**: Basic podium mic vs. full concert production requires very different cue sheets
5. **State known risks**: International speaker travel, outdoor venue weather exposure, or untested technology shapes contingency planning
6. **Request the right scale**: Ask for a streamlined 2-page document for simple events, or a full production bible for complex ones

## Run-of-Show Checklist

Use this before distributing the final document:

```
[ ] Every minute accounted for from load-in to load-out
[ ] 5-minute buffer between every session transition
[ ] All staff members assigned to specific roles with radio channels
[ ] Speaker timeline includes green room, mic check, and transitions
[ ] AV cue sheet created for lighting, sound, and video operators
[ ] Catering service times coordinated with program schedule
[ ] Contingency plan for each major risk category
[ ] Emergency contacts list complete
[ ] Load-out sequence and venue clear time confirmed
[ ] Document version-numbered and dated
[ ] Physical copies printed for day-of use
[ ] All stakeholders received final version 48 hours before event
```

---
Downloaded from [FindSkill.ai](https://findskill.ai)
