---
name: festival-concert-planner
version: 1.0.0
description: Plan music festivals, concerts, and multi-day events with packing lists, schedule optimization, budgeting, camping logistics, and survival tips
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for planning music festivals, concerts, and multi-day live events. No scripts or additional files are needed --- simply use SKILL.md directly with any AI assistant.

The skill helps with:
- Festival type assessment (camping, city, EDM, genre-specific, international)
- Ticket strategy (tiers, timing, resale, scam avoidance)
- Accommodation selection (camping, glamping, hotels, Airbnb, commuting)
- Transportation planning (driving, flying, shuttles, rideshare, public transit)
- Comprehensive packing lists tailored by festival type and genre
- Schedule optimization with lineup prioritization, conflict resolution, and discovery time
- Budget planning with per-person breakdowns and money-saving strategies
- Festival survival (hydration, sun protection, crowd safety, hearing protection)
- Group coordination (shared gear, schedule compromise, meeting points, cost splitting)
- Health and safety (first aid, harm reduction, weather preparedness)
- Food strategy (vendor optimization, campsite cooking, dietary restrictions)
- Post-festival recovery (physical recovery, photo organization, lost and found)
- International festival logistics (passport, insurance, currency, cultural norms)

## Directory Structure

```
festival-concert-planner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None --- this is a prompt-only skill.

## Files to Generate

None --- the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r festival-concert-planner/ ~/.claude/skills/festival-concert-planner/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start planning your festival experience!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- LLaMA (Meta)
- Mistral

## Variables

Customize these for your specific event:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_name}}` | Coachella | Name of the festival or concert |
| `{{event_type}}` | multi-day camping festival | Type of event: camping festival, city festival, EDM event, single-day concert |
| `{{duration_days}}` | 3 | Number of days for the event |
| `{{group_size}}` | 4 friends | Number of people attending together |
| `{{budget}}` | $1500 per person | Total per-person budget including tickets, travel, food, and extras |

## Example Usage

After loading the skill, try prompts like:

**First-timer at a camping festival:**
"I'm going to Bonnaroo for the first time with 3 friends. We have $1200 each and plan to car camp. Help me with a complete packing list, budget breakdown, and schedule strategy. I'm most excited about the Friday and Saturday headliners but want to discover new artists too."

**Solo international festival trip:**
"I'm flying from the US to Glastonbury in the UK for 5 days. Budget is $3000 total. I've never been to a European festival. Help me plan everything from flights and camping gear to dealing with mud, rain, and jet lag."

**Group EDM festival:**
"Planning a trip to Tomorrowland in Belgium for 6 of us. We want the Dreamville camping experience. Budget is $2500 per person. Help us coordinate packing, schedule our must-see DJs across 3 days, and set up our campsite."

**Budget-friendly city festival:**
"Going to Lollapalooza in Chicago with my partner. We're on a tight budget of $800 total for both of us (tickets already bought). Need help finding cheap accommodation, planning which days to attend, and maximizing our food budget."

**Family-friendly festival:**
"Taking my partner and 2 kids (ages 8 and 12) to Austin City Limits. Budget is $2000 for the family. Need help with kid-friendly planning, age-appropriate schedule, and what to pack for a city festival with children."

## Tips for Best Results

1. **Name the specific festival**: The skill gives better advice when it knows the exact event (venue layout, climate, culture)
2. **Mention your experience level**: First-timer advice is fundamentally different from veteran optimization
3. **Be honest about budget**: Include everything (tickets, travel, food, gear) for realistic planning
4. **Specify camping vs non-camping**: Packing lists and logistics change completely
5. **List health needs**: Dietary restrictions, medications, mobility concerns, and allergies affect every phase of planning
6. **Share your music priorities**: Name specific artists or genres for tailored schedule optimization
7. **Use it iteratively**: Start with the big picture (budget, accommodation, transport), then drill into packing, schedule, and day-of logistics

---
Downloaded from [FindSkill.ai](https://findskill.ai)
