---
name: food-allergy-travel-card-creator
version: 1.0.0
description: Generate multilingual food allergy communication cards for international travel covering 14 EU-classified allergens, hidden ingredient warnings, cross-contamination instructions, emergency medical phrases, and restaurant communication scripts in 30+ languages
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for generating comprehensive, life-saving food allergy communication cards for international travelers. No scripts or additional files are needed -- simply use SKILL.md directly with any AI assistant.

The skill helps travelers who have food allergies, intolerances, or dietary restrictions communicate their needs to restaurant staff, street food vendors, hotel kitchens, airline catering, and medical professionals in any country, in the local language.

Core capabilities:
- All 14 EU-classified major allergens with hidden sources in global cuisines (cereals/gluten, crustaceans, eggs, fish, peanuts, soybeans, milk/dairy, tree nuts, celery, mustard, sesame, sulfites, lupin, mollusks)
- Card generation in 35+ languages with native script, proper grammar, and phonetic pronunciation
- Three severity levels: mild intolerance, moderate allergy, severe/anaphylaxis risk
- Destination-specific hidden ingredient warnings (dishes that secretly contain allergens)
- Cross-contamination instructions for kitchen staff
- Emergency medical phrases with pronunciation guides
- Restaurant communication scripts for verbal explanation
- Pharmacy and hospital vocabulary in target languages
- Dietary restriction combinations (allergy + vegan, + kosher, + halal, + celiac)
- Country-specific cultural context for how allergy communication is received
- Multiple card formats: phone screen, printable wallet card, full restaurant card, multi-language card
- Emergency contact QR code text generation
- Travel safety checklists and country-specific emergency numbers

## Directory Structure

```
food-allergy-travel-card-creator/
├── SKILL.md    # Main skill instructions (condensed)
├── INIT.md     # This initialization file
└── index.md    # Full skill with comprehensive allergen database
```

## Dependencies

None -- this is a prompt-only skill.

## Files to Generate

None -- the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r food-allergy-travel-card-creator/ ~/.claude/skills/food-allergy-travel-card-creator/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Tell it your allergies, severity, destination, and target language

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- LLaMA (Meta)
- Mistral
- Any open-source LLM with instruction-following capability

## Variables

Customize these for your specific trip:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{allergies}}` | peanuts, tree nuts | Your specific food allergies or intolerances |
| `{{target_language}}` | Japanese | The language for the allergy card |
| `{{severity_level}}` | severe (anaphylaxis risk) | How severe your allergic reactions are |
| `{{dietary_restrictions}}` | none | Additional dietary restrictions (vegan, kosher, halal, celiac) |
| `{{travel_destination}}` | Tokyo, Japan | The city and country you are traveling to |

## Example Usage

After loading the skill, try prompts like:

**Severe peanut allergy in Japan:**
"Create a food allergy card in Japanese for someone with severe peanut and tree nut allergies traveling to Tokyo. Include emergency phrases, hidden ingredient warnings for common Japanese dishes, and cross-contamination instructions."

**Celiac disease in Italy:**
"I have celiac disease and I'm traveling to Rome and Florence for two weeks. Generate a detailed gluten-free communication card in Italian with hidden gluten warnings in Italian cuisine, safe pasta alternatives, and emergency medical vocabulary."

**Multiple allergies in Thailand:**
"I'm allergic to shrimp (severe/anaphylaxis) and eggs (moderate). I'm backpacking through Thailand for a month and will eat mostly street food. Create a card in Thai with extra emphasis on shrimp paste (kapi) hidden in dishes and safe Thai dishes I can order."

**Allergy + vegan in South Korea:**
"I'm vegan with a severe sesame allergy traveling to Seoul. Create a Korean-language card that clearly separates my vegan preference from my medical allergy, with warnings about sesame oil in Korean cooking and safe dishes I can eat."

**Multi-country Europe trip:**
"I have a severe dairy allergy. I'm traveling through France, Italy, and Spain over three weeks. Generate allergy cards in French, Italian, and Spanish with country-specific hidden dairy warnings and safe local dishes for each country."

**Traveling with an allergic child:**
"My 6-year-old has severe allergies to eggs, peanuts, and tree nuts. We're going to a family resort in Mexico. Create a Spanish-language card with simplified language, child-specific emergency instructions, and safe Mexican foods for kids."

## The 14 Major Allergens Reference

This skill covers all 14 allergens classified under EU Regulation No 1169/2011:

| # | Allergen | Key Hidden Sources |
|---|----------|--------------------|
| 1 | Cereals/Gluten | Soy sauce (wheat), tempura, roux, bread |
| 2 | Crustaceans | Shrimp paste, XO sauce, kimchi |
| 3 | Eggs | Fresh pasta, katsu coating, Chinese pastries |
| 4 | Fish | Dashi, fish sauce, Worcestershire sauce |
| 5 | Peanuts | Satay, pad Thai, African groundnut stew |
| 6 | Soybeans | Soy sauce, miso, tofu, soybean oil |
| 7 | Milk/Dairy | Ghee, naan, cream sauces, curry roux |
| 8 | Tree nuts | Pesto, korma, baklava, marzipan |
| 9 | Celery | Mirepoix, stocks, German sausages |
| 10 | Mustard | Vinaigrettes, Indian tadka, sauces |
| 11 | Sesame | Korean cooking, tahini, simit, bread |
| 12 | Sulfites | Wine, dried fruit, processed potatoes |
| 13 | Lupin | European gluten-free baked goods |
| 14 | Mollusks | Oyster sauce, calamari, seafood stock |

## Card Sections Generated

Every complete allergy card includes these 8 sections:

1. **Primary Alert Header** -- severity-coded bilingual warning
2. **Specific Allergens List** -- with local names and synonyms
3. **Hidden Ingredient Warnings** -- destination-specific danger dishes
4. **Cross-Contamination Warning** -- kitchen staff instructions
5. **Safe Food Requests** -- local dishes the person CAN eat
6. **Emergency Medical Information** -- symptoms, EpiPen, emergency numbers
7. **Restaurant Communication Script** -- verbal explanation with pronunciation
8. **Pharmacy/Medical Vocabulary** -- hospital and pharmacy terms

## Tips for Best Results

1. **Be specific about severity**: "I carry an EpiPen for peanut anaphylaxis" gets a better card than "peanut allergy"
2. **Name the destination city**: cuisine varies within countries (coastal vs. inland, tourist vs. local)
3. **Mention dining context**: street food, fine dining, hotel breakfast, and airline meals all need different emphasis
4. **List ALL allergens**: do not assume the AI knows your full allergy profile
5. **Specify dietary combos**: if you are vegan + allergic, or kosher + allergic, say so upfront
6. **Request multiple formats**: ask for both a phone screen version and a printable wallet card
7. **Verify with native speakers**: for life-threatening allergies, have a native speaker review the card before travel
8. **Update for each trip**: cuisine and ingredient norms differ by destination

## Research Sources

This skill's allergen database and cultural context draws from:
- EU Regulation No 1169/2011 (14 major allergens classification)
- FARE (Food Allergy Research & Education) travel resources
- World Allergy Organization anaphylaxis guidelines
- Codex Alimentarius international food labeling standards
- Country-specific allergen labeling regulations (Japan's Consumer Affairs Agency, US FASTER Act, etc.)
- Celiac Disease Foundation international travel guides

---
Downloaded from [FindSkill.ai](https://findskill.ai)
