---
name: gift-idea-generator
version: 1.0.0
description: Personalized gift recommendations based on recipient interests, relationship, occasion, and budget
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for generating personalized gift recommendations. No scripts or additional files are needed - simply use SKILL.md directly with any AI assistant.

The skill helps with:
- Interest-based gift matching
- Budget-tiered recommendations
- Occasion-specific guidance
- Hard-to-buy-for solutions
- Last-minute gift options
- Relationship-specific ideas

## Directory Structure

```
gift-idea-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r gift-idea-generator/ ~/.claude/skills/gift-idea-generator/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start finding perfect gifts!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Variables

Customize these for your gift search:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{recipient}}` | my mom | Who the gift is for |
| `{{relationship}}` | daughter | Your relationship to them |
| `{{occasion}}` | birthday | What the gift is for |
| `{{budget}}` | $50-100 | How much to spend |
| `{{interests}}` | gardening, cooking, reading | Their hobbies/passions |
| `{{age}}` | 65 | Approximate age |

## Example Usage

After loading the skill, try prompts like:

**Detailed gift search:**
"I need a Christmas gift for my brother-in-law. He's 34, into woodworking and craft beer, just got a Traeger smoker. Budget is $75-100. He's hard to buy for because he buys himself whatever he wants."

**Quick suggestions:**
"Gift ideas for a 10-year-old girl who loves art and horses. Budget $30."

**Hard-to-buy-for:**
"My dad has everything and returns most gifts. He's 68, retired, likes golf and history documentaries. What can I get for Christmas under $100 that he might actually keep?"

**Last-minute:**
"I forgot my coworker's birthday is tomorrow! She's into yoga and plants. Need something I can get today, under $40."

**Multiple recipients:**
"Help me plan Christmas gifts for my family - mom (65, gardener), dad (67, golfer), sister (38, new baby), brother (35, tech guy). Total budget $400."

## Tips for Best Results

1. **Share details**: Random facts often spark perfect ideas
2. **Mention past gifts**: Avoid repeating or getting similar items
3. **State personality**: Practical vs. sentimental matters a lot
4. **Include restrictions**: No clutter, dietary needs, allergies
5. **Ask for alternatives**: Request multiple options per category
6. **Specify where to buy**: Ask for specific retailers if needed

## Supported Occasions

- Birthdays (all ages)
- Christmas/Hanukkah/holidays
- Anniversaries
- Weddings
- Baby showers
- Graduations
- Mother's Day/Father's Day
- Valentine's Day
- Thank you gifts
- Host/hostess gifts
- Get well gifts
- Retirement
- Housewarming
- Just because

---
Downloaded from [FindSkill.ai](https://findskill.ai)
